import { AppointmentStatus, IAppointment, IMedicalCenter, IDoctor, AppointmentType } from "../types/appointment";
import { TableColumn } from "../types/common";

export const DRIVERS = [
  { value: "Jean Dupont", label: "Jean Dupont" },
  { value: "Marie Martin", label: "Marie Martin" },
  { value: "Pierre Durant", label: "Pierre Durant" },
  { value: "Sophie Bernard", label: "Sophie Bernard" },
  { value: "Lucas Petit", label: "Lucas Petit" },
];

export const MEDICAL_CENTERS: IMedicalCenter[] = [
  { id: 'MC1', name: 'Centre Médical Nord', address: '123 Avenue du Nord' },
  { id: 'MC2', name: 'Clinique Centrale', address: '45 Rue de la Santé' },
  { id: 'MC3', name: 'Centre Médical Est', address: '78 Boulevard Est' },
  { id: 'MC4', name: 'Clinique Ouest', address: '90 Avenue Ouest' },
];

export const MEDICAL_CENTER_OPTIONS = MEDICAL_CENTERS.map(center => ({
  value: center.id,
  label: center.name
}));

export const DOCTORS: IDoctor[] = [
  { id: 'DR1', name: 'Dr. Martin', medicalCenterId: 'MC1' },
  { id: 'DR2', name: 'Dr. Dubois', medicalCenterId: 'MC1' },
  { id: 'DR3', name: 'Dr. Bernard', medicalCenterId: 'MC2' },
  { id: 'DR4', name: 'Dr. Thomas', medicalCenterId: 'MC2' },
  { id: 'DR5', name: 'Dr. Robert', medicalCenterId: 'MC3' },
  { id: 'DR6', name: 'Dr. Petit', medicalCenterId: 'MC3' },
  { id: 'DR7', name: 'Dr. Laurent', medicalCenterId: 'MC4' },
  { id: 'DR8', name: 'Dr. Michel', medicalCenterId: 'MC4' },
];

export const DOCTOR_OPTIONS = DOCTORS.map(doctor => ({
  value: doctor.id,
  label: doctor.name
}));

export const APPOINTMENT_STATUS: { value: AppointmentStatus; label: string }[] = [
  { value: 'prevu', label: 'Prévu' },
  { value: 'termine', label: 'Terminé' },
  { value: 'annule', label: 'Annulé' },
];
export const APPOINTMENT_TYPES = [
  { value: 'Visite Médicale (médecine du travail)', label: 'Visite Médicale (médecine du travail)' },
  { value: 'Visite Médicale (Préfectorale)', label: 'Visite Médicale (Préfectorale)' },
  { value: 'Entretien Annuel', label: 'Entretien Annuel' },
  { value: 'Formation', label: 'Formation' },
  { value: 'Autre', label: 'Autre' },
];


export const _appointments: IAppointment[] = [...Array(24)].map((_, index) => {
  const today = new Date();
  const appointmentDate = new Date(today);
  appointmentDate.setDate(today.getDate() + index % 14);
  const statuses: AppointmentStatus[] = ['prevu', 'termine', 'annule'];
  const status = statuses[index % 3];
  const type = APPOINTMENT_TYPES[index % APPOINTMENT_TYPES.length].label as AppointmentType ;

  let doctorId = '';
  let doctorName = '';
  let medicalCenterId = '';
  let medicalCenterName = '';
  let otherType = '';

  if (type === 'Visite Médicale (médecine du travail)') {
    const medicalCenter = MEDICAL_CENTERS[index % MEDICAL_CENTERS.length];
    const doctors = DOCTORS.filter(d => d.medicalCenterId === medicalCenter.id);
    const doctor = doctors[index % doctors.length];
    
    doctorId = doctor.id;
    doctorName = doctor.name;
    medicalCenterId = medicalCenter.id;
    medicalCenterName = medicalCenter.name;
  } else if (type === 'Autre') {
    otherType = 'Description du type personnalisé';
  }

  return {
    id: (index + 1).toString(),
    driverId: `CHF-${(index + 1).toString().padStart(3, '0')}`,
    driverName: DRIVERS[index % DRIVERS.length].value,
    doctorId,
    doctorName,
    medicalCenterId,
    medicalCenterName,
    date: appointmentDate.toISOString().split('T')[0],
    time: `${(8 + index % 8).toString().padStart(2, '0')}:00`,
    status,
    type,
    otherType,
    comments: "Commentaires sur le rendez-vous",
    createdAt: new Date().toISOString(),
    updatedAt: new Date().toISOString(),
  };
});

export const DEFAULT_APPOINTMENT_HEAD: TableColumn[] = [
  { id: 'driverName', label: 'Chauffeur', type: 'text' },
  { id: 'type', label: 'Type', type: 'text' },
  { id: 'doctorName', label: 'Médecin', type: 'text' },
  { id: 'medicalCenterName', label: 'Centre médical', type: 'text' },
  { id: 'otherType', label: 'Précision', type: 'text' },
  { id: 'status', label: 'Statut', type: 'status' },
  { id: 'date', label: 'Date', type: 'date' },
  { id: 'time', label: 'Heure', type: 'text' },
  { id: '', label: 'Actions' },
];

export const INITIAL_APPOINTMENT_DATA: IAppointment = {
  id: '',
  driverId: '',
  driverName: '',
  type: 'Visite Médicale (médecine du travail)',
  otherType: '',
  doctorId: '',
  doctorName: '',
  medicalCenterId: '',
  medicalCenterName: '',
  date: '',
  time: '',
  status: 'prevu',
  comments: '',
  createdAt: new Date().toISOString(),
  updatedAt: new Date().toISOString(),
};