import { TableColumn } from '../types/common';
import { BesoinRecrutementStatut, IBesoinRecrutement, INITIAL_BESOIN_RECRUTEMENT_DATA } from '../types/besoin-recrutement';
import { nanoid } from 'nanoid';

export const DEFAULT_BESOIN_RECRUTEMENT_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', type: 'text', align: 'left' },
  { id: 'demandeur', label: 'Demandeur', type: 'text', align: 'left' },
  { id: 'motif', label: 'Motif du besoin', type: 'text', align: 'left' },
  { id: 'nombrePostes', label: 'Postes', type: 'text', align: 'left' },
  { id: 'departement', label: 'Département', type: 'text', align: 'left' },
  { id: 'circuit', label: 'Circuit', type: 'text', align: 'left' },
  { id: 'dateCreation', label: 'Date de création', type: 'date', align: 'left' },
  { id: 'statut', label: 'Statut', type: 'text', align: 'left' },
  { id: 'actions', label: 'Actions', type: 'text', align: 'left' },
];

export const DEFAULT_BESOIN_RECRUTEMENT_EN_ATTENTE_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', type: 'text', align: 'left' },
  { id: 'demandeur', label: 'Demandeur', type: 'text', align: 'left' },
  { id: 'motif', label: 'Motif du besoin', type: 'text', align: 'left' },
  { id: 'nombrePostes', label: 'Postes', type: 'text', align: 'left' },
  { id: 'departement', label: 'Département', type: 'text', align: 'left' },
  { id: 'circuit', label: 'Circuit', type: 'text', align: 'left' },
  { id: 'dateCreation', label: 'Date de création', type: 'date', align: 'left' },
  { id: 'statut', label: 'Statut', type: 'text', align: 'left' },
  { id: 'actions', label: 'Actions', type: 'text', align: 'left' },
];

export const DEFAULT_BESOIN_RECRUTEMENT_EN_COURS_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', type: 'text', align: 'left' },
  { id: 'demandeur', label: 'Demandeur', type: 'text', align: 'left' },
  { id: 'motif', label: 'Motif du besoin', type: 'text', align: 'left' },
  { id: 'nombrePostes', label: 'Postes', type: 'text', align: 'left' },
  { id: 'departement', label: 'Département', type: 'text', align: 'left' },
  { id: 'circuit', label: 'Circuit', type: 'text', align: 'left' },
  { id: 'dateCreation', label: 'Date de création', type: 'date', align: 'left' },
  { id: 'statut', label: 'Statut', type: 'text', align: 'left' },
  { id: 'actions', label: 'Actions', type: 'text', align: 'left' },
];

export const DEFAULT_BESOIN_RECRUTEMENT_TRAITES_TABLE_HEAD: TableColumn[] = [
  { id: 'demandeur', label: 'Demandeur', type: 'text', align: 'left' },
  { id: 'motif', label: 'Motif du besoin', type: 'text', align: 'left' },
  { id: 'nombrePostes', label: 'Postes', type: 'text', align: 'left' },
  { id: 'departement', label: 'Département', type: 'text', align: 'left' },
  { id: 'circuit', label: 'Circuit', type: 'text', align: 'left' },
  { id: 'dateCreation', label: 'Date de création', type: 'date', align: 'left' },
  { id: 'statut', label: 'Statut', type: 'text', align: 'left' },
  { id: 'candidatureAssocieeId', label: 'Candidature associée', type: 'text', align: 'left' },
  { id: 'actions', label: 'Actions', type: 'text', align: 'left' },
];

export const DEFAULT_BESOIN_RECRUTEMENT_TOUS_TABLE_HEAD: TableColumn[] = [
  { id: 'demandeur', label: 'Demandeur', type: 'text', align: 'left' },
  { id: 'motif', label: 'Motif du besoin', type: 'text', align: 'left' },
  { id: 'nombrePostes', label: 'Postes', type: 'text', align: 'left' },
  { id: 'departement', label: 'Département', type: 'text', align: 'left' },
  { id: 'circuit', label: 'Circuit', type: 'text', align: 'left' },
  { id: 'dateCreation', label: 'Date de création', type: 'date', align: 'left' },
  { id: 'statut', label: 'Statut', type: 'text', align: 'left' },
  { id: 'actions', label: 'Actions', type: 'text', align: 'left' },
];

// Mock data for besoins de recrutement
export const _besoinsRecrutement: IBesoinRecrutement[] = [
  {
    id: '1',
    demandeur: 'Jean Dupont',
    motif: 'Remplacement congé maternité',
    nombrePostes: 1,
    departement: 'Exploitation',
    circuit: 'Circuit Nord',
    statut: BesoinRecrutementStatut.EnAttente,
    dateCreation: '2023-02-15',
    observation: 'Besoin urgent pour le service exploitation'
  },
  {
    id: '2',
    demandeur: 'Marie Martin',
    motif: 'Nouvelle embauche',
    nombrePostes: 2,
    departement: 'Flotte',
    circuit: 'Circuit Sud',
    statut: BesoinRecrutementStatut.EnCours,
    dateCreation: '2023-02-10',
    observation: 'Expansion de l\'équipe de gestion de flotte'
  },
  {
    id: '3',
    demandeur: 'Pierre Durand',
    motif: 'Fin de contrat',
    nombrePostes: 1,
    departement: 'Exploitation',
    circuit: 'Circuit Est',
    statut: BesoinRecrutementStatut.Traite,
    dateCreation: '2023-01-25',
    candidatureAssocieeId: '2',
    observation: 'Remplacement suite à un départ'
  },
  {
    id: '4',
    demandeur: 'Sophie Leroy',
    motif: 'Remplacement démission',
    nombrePostes: 1,
    departement: 'Administration',
    circuit: 'Circuit Ouest',
    statut: BesoinRecrutementStatut.EnAttente,
    dateCreation: '2023-02-18',
    observation: 'Poste à pourvoir rapidement'
  },
  {
    id: '5',
    demandeur: 'Lucas Moreau',
    motif: 'Augmentation d\'activité',
    nombrePostes: 3,
    departement: 'Exploitation',
    circuit: 'Circuit Nord',
    statut: BesoinRecrutementStatut.EnCours,
    dateCreation: '2023-02-05',
    observation: 'Besoin de renforcer l\'équipe d\'exploitation'
  },
  {
    id: '6',
    demandeur: 'Emma Petit',
    motif: 'Remplacement maladie longue durée',
    nombrePostes: 1,
    departement: 'Maintenance',
    circuit: 'Circuit Centre',
    statut: BesoinRecrutementStatut.Traite,
    dateCreation: '2023-01-15',
    candidatureAssocieeId: '5',
    observation: 'Remplacement temporaire'
  },
  {
    id: '7',
    demandeur: 'Thomas Bernard',
    motif: 'Création de poste',
    nombrePostes: 2,
    departement: 'Technique',
    circuit: 'Circuit Est',
    statut: BesoinRecrutementStatut.EnAttente,
    dateCreation: '2023-02-20',
    observation: 'Nouveau service de maintenance'
  },
  {
    id: '8',
    demandeur: 'Camille Dubois',
    motif: 'Remplacement retraite',
    nombrePostes: 1,
    departement: 'Flotte',
    circuit: 'Circuit Sud',
    statut: BesoinRecrutementStatut.EnCours,
    dateCreation: '2023-02-08',
    observation: 'Départ à la retraite prévu fin mars'
  }
]; 