import { TableColumn } from "../types/common";
import { Interval } from "../types/chauffeur";
import { DaySchedule, ITripDriverAssignment, WeekTypeSchedule } from "../types/circuit";
import { PeriodOfDay } from "../types/ammendment-passenger";
import { DaysOfWeek, WeekType } from "../types/passenger";

const randomTime = () => {
  const hours = Math.floor(Math.random() * 24).toString().padStart(2, '0');
  const minutes = Math.floor(Math.random() * 60).toString().padStart(2, '0');
  return `${hours}:${minutes}`;
};

const generateRandomSchedule = (weekType: WeekType): WeekTypeSchedule => {
  const days = Object.values(DaysOfWeek);
  const periods = Object.values(PeriodOfDay);
  
  const selectedPeriods: DaySchedule[] = [];
  
  const dayCount = 3 + Math.floor(Math.random() * 3);
  const selectedDays = days.sort(() => 0.5 - Math.random()).slice(0, dayCount);
  
  selectedDays.forEach(day => {
    const periodCount = Math.random() > 0.5 ? 2 : 1;
    const selectedPeriodsForDay = periods.sort(() => 0.5 - Math.random()).slice(0, periodCount);
    
    selectedPeriodsForDay.forEach(period => {
      selectedPeriods.push({
        dayOfWeek: day,
        periodOfDay: period
      });
    });
  });
  
  return {
    weekType,
    periods: selectedPeriods
  };
};

export const _chauffeurs: ITripDriverAssignment[] = [...Array(5)].map((_, index) => {
  const startTime = randomTime();
  const endTime = randomTime();
  const assignmentStartDate = new Date(2002 + Math.floor(index / 12), index % 12, 15);
  const assignmentEndDate = new Date(assignmentStartDate.getFullYear() + 2, Math.floor(Math.random() * 12), 1);

  const weeklyAssignmentSchedule: WeekTypeSchedule[] = [
    generateRandomSchedule(WeekType.EVEN),
    generateRandomSchedule(WeekType.ODD)
  ];

  const trajet: Interval = {
    depart: `${['Collège', 'École', 'Lycée'][Math.floor(Math.random() * 3)]} ${String.fromCharCode(65 + index)}`,
    arriver: `${['École', 'Collège', 'Lycée'][Math.floor(Math.random() * 3)]} ${String.fromCharCode(75 + index)}`,
  };

  const horaires: Interval = {
    depart: startTime,
    arriver: endTime,
  };

  return {
    id: (index + 1).toString(),
    driverId: index + 1,
    driverName: `${['Jean', 'Marie', 'Pierre', 'Sophie', 'Luc'][Math.floor(Math.random() * 5)]} ${['Dupont', 'Martin', 'Bernard', 'Petit', 'Durand'][Math.floor(Math.random() * 5)]}`,
    tripId : trajet.depart + ' -> ' + trajet.arriver,
    horaires,
    assignmentStartDate: assignmentStartDate.toISOString().split('T')[0],
    assignmentEndDate: assignmentEndDate.toISOString().split('T')[0],
    replacedByDriverId: 0,
    observations: ['Trajet régulier', 'Modification ponctuelle', 'Remplacement temporaire'][Math.floor(Math.random() * 3)],
    isActive: true,
    weeklyAssignmentSchedule,
    createdAt: '',
    updatedAt: '',
  };
});

export const DEFAULT_CHAUFFEUR_TABLE_HEAD: TableColumn[] = [
  { id: 'driverId', label: 'N° chauffeur', type: 'text', align: 'left' },
  { id: 'tripId', label: 'Trajet', type: 'text', align: 'left' },
  { id: 'horaires', label: 'Horaires', type: 'text', align: 'center' },
  { id: 'assignmentStartDate', label: 'A partir du', type: 'date', align: 'center' },
  { id: 'assignmentEndDate', label: 'Jusqu\'au', type: 'date', align: 'center' },
  { id: 'driverName', label: 'Chauffeur', type: 'text', align: 'left' },
  { id: 'weeklyAssignmentSchedule', label: 'Jours attribués', type: 'text', align: 'center' },
  { id: 'observations', label: 'Observation', type: 'text', align: 'left' },
];



export const INITIAL_TRIP_DRIVER_ASSIGNMENT_DATA: ITripDriverAssignment = {
  id: '',
  createdAt: '',
  updatedAt: '',
  weeklyAssignmentSchedule: [],
  assignmentStartDate: '',
  assignmentEndDate: '',
  tripId: '',
  driverId: 0,
  replacedByDriverId: 0,
  observations: '',
  isActive: true,
}
