import { tr } from "date-fns/locale"
import type { TableColumn } from "../types/common"
import { type IDemande, TypeDemande, PrioriteDemande } from "../types/demande"
import { DemandeStatus } from "../types/demande"

export const _demandes: IDemande[] = [...Array(8)].map((_, index) => {
  const creationDate = new Date(2023, Math.floor(Math.random() * 12), Math.floor(Math.random() * 28) + 1)
  const updateDate = new Date(creationDate)
  updateDate.setDate(updateDate.getDate() + Math.floor(Math.random() * 14))

  // Randomly set expiration date (some documents might not have one)
  let expirationDate = null
  if (Math.random() > 0.3) {
    expirationDate = new Date(creationDate)
    expirationDate.setFullYear(expirationDate.getFullYear() + 1)
  }

  // Rotate through all status values
  const statuses = [
    DemandeStatus.EN_ATTENTE,
    DemandeStatus.EN_TRAITEMENT,
    DemandeStatus.VALIDEE,
    DemandeStatus.REFUSEE,
  ]

  // Rotate through all types
  const types = [
    TypeDemande.JUSTIFICATIF_PERSONNEL,
    TypeDemande.DOCUMENT_OFFICIEL,
    TypeDemande.FICHIER_ADMINISTRATIF,
    TypeDemande.CONTRAT_TRAVAIL,
    TypeDemande.AUTRE,
  ]

  // Rotate through priorities
  const priorities = [PrioriteDemande.BASSE, PrioriteDemande.NORMALE, PrioriteDemande.HAUTE, PrioriteDemande.URGENTE]

  // Random users
  const users = ["Jean Dupont", "Marie Martin", "Sophie Bernard", "Thomas Petit", "Camille Dubois"]

  // Random document titles
  const titles = [
    "Attestation de travail",
    "Certificat de résidence",
    "Relevé d'identité bancaire",
    "Justificatif de domicile",
    "Contrat à durée indéterminée",
    "Bulletin de salaire",
    "Attestation de sécurité sociale",
    "Carte d'identité professionnelle",
  ]

  return {
    id: (index + 1).toString(),
    numeroDemande: `DEM-${(index + 1).toString().padStart(6, "0")}`,
    utilisateur: users[Math.floor(Math.random() * users.length)],
    typeDemande: types[index % types.length],
    intitule: titles[index % titles.length],
    description: `Demande de ${titles[index % titles.length].toLowerCase()} pour dossier administratif`,
    dateCreation: creationDate.toISOString().split("T")[0],
    dateMiseAJour: updateDate.toISOString().split("T")[0],
    dateExpiration: expirationDate ? expirationDate.toISOString().split("T")[0] : undefined,
    status: statuses[index % statuses.length],
    priorite: priorities[index % priorities.length],
    commentaire: Math.random() > 0.5 ? "Merci de traiter cette demande rapidement" : undefined,
    documentAssocie:
      Math.random() > 0.7 ? `D-${(Math.floor(Math.random() * 5) + 1).toString().padStart(7, "0")}` : undefined,
    fichierAttache: Math.random() > 0.5,
    actif: Math.random() > 0.3,
  }
})

export const DEFAULT_DEMANDE_TABLE_HEAD: TableColumn[] = [
  { id: "numeroDemande", label: "N° demande", type: "text" },
  { id: "intitule", label: "Intitulé", type: "text" },
  { id: "typeDemande", label: "Type", type: "text" },
  { id: "dateCreation", label: "Date Soumission", type: "date" },
  { id: "status", label: "Statut", type: "text" },
  { id: "priorite", label: "Priorité", type: "text" },
  { id: "action", label: "Action" },
]
export const DEFAULT_DEMANDE_FILTERS: TableColumn[] = [
  { id: "numeroDemande", label: "N° demande", type: "text" },
  { id: "intitule", label: "Intitulé", type: "text" },
  { id: "typeDemande", label: "Type", type: "text" },
  { id: "dateCreation", label: "Date Soumission", type: "date" },
  { id: "status", label: "Statut", type: "text" },
  { id: "actif", label: "Actif", type: "boolean"},
]

export const INITIAL_DEMANDE_DATA: IDemande = {
  id: "",
  numeroDemande: "",
  utilisateur: "",
  typeDemande: TypeDemande.JUSTIFICATIF_PERSONNEL,
  intitule: "",
  description: "",
  dateCreation: "",
  dateMiseAJour: "",
  status: DemandeStatus.EN_ATTENTE,
  priorite: PrioriteDemande.NORMALE,
  actif:true
}

