// _department.ts
import { IDepartment } from '@/shared/types/infrastructure';
import { TableColumn } from '../types/common';
import { INITIAL_ADDRESS, MOCK_ADDRESSES } from '.';

export const DEFAULT_DEPARTMENT_TABLE_HEAD: TableColumn[] = [
    { id: 'name', label: 'Nom', align: 'left' },
    { id: 'description', label: 'Description', align: 'left' },
    { id: 'createdAt', label: 'Créé le', align: 'left' },
    { id: 'updatedAt', label: 'Mis à jour le', align: 'left' },
    { id: 'lotsNbr', label: 'Nombre de lots', align: 'left' },
];

export const INITIAL_DEPARTMENT_DATA: IDepartment = {
    id: '',
    name: '',
    adresse:INITIAL_ADDRESS,
    description: '',
    createdAt: new Date().toISOString().split('T')[0],
    updatedAt: new Date().toISOString().split('T')[0],
    lotsNbr: 0,
};

const getCurrentDate = () => new Date().toISOString().split('T')[0];

const generateLot = (id: string, lotNumber: string) => ({
    id,
    name: `Lot ${lotNumber}`,
    lotNumber,
    description: `Description ${lotNumber}`,
    createdAt: getCurrentDate(),
    updatedAt: getCurrentDate()
});

const generateAgency = () => ({
    id: "1",
    name: 'Agence 1',
    description: 'Description 1',
    adresse: MOCK_ADDRESSES[Math.floor(Math.random() * MOCK_ADDRESSES.length)],
    createdAt: getCurrentDate(),
    updatedAt: getCurrentDate(),
    departmentsNbr: 3,
});

const departmentList = [
    { name: 'Département Ressources Humaines', description: 'Gestion du personnel et recrutement', lotsNbr: 5 },
    { name: 'Département Finance', description: 'Gestion budgétaire et comptabilité', lotsNbr: 3 },
    { name: 'Département IT', description: 'Support technique et développement', lotsNbr: 4 },
    { name: 'Département Marketing', description: 'Stratégies de promotion et communication', lotsNbr: 6 },
    { name: 'Département Ventes', description: 'Gestion des ventes et clients', lotsNbr: 7 },
    { name: 'Département Logistique', description: 'Gestion des transports et livraisons', lotsNbr: 4 },
    { name: 'Département Production', description: 'Supervision de la production', lotsNbr: 8 },
    { name: 'Département Qualité', description: 'Contrôle qualité et normes', lotsNbr: 3 },
    { name: 'Département R&D', description: 'Recherche et développement', lotsNbr: 5 },
    { name: 'Département Juridique', description: 'Affaires légales et conformité', lotsNbr: 2 },
    { name: 'Département Communication', description: 'Relations publiques et médias', lotsNbr: 4 },
    { name: 'Département Achats', description: 'Gestion des approvisionnements', lotsNbr: 6 },
    { name: 'Département Sécurité', description: 'Sécurité des installations', lotsNbr: 3 }
];

export const _departments: IDepartment[] = departmentList.map((dept, index) => ({
    id: (index + 1).toString(),
    name: dept.name,
    adresse: MOCK_ADDRESSES[Math.floor(Math.random() * MOCK_ADDRESSES.length)],
    description: dept.description,
    createdAt: getCurrentDate(),
    updatedAt: getCurrentDate(),
    lotsNbr: dept.lotsNbr,
    agency: generateAgency(),
    lots: Array.from({ length: 3 }, (_, i) => generateLot((i + 1).toString(), (i + 1).toString()))
}));