import { fileTypes } from ".";
import { TableColumn } from "../types/common";
import { Folder, IDocument, ISuiviDocument } from "../types/document";

export const _documents: IDocument[] = [...Array(4)].map((_, index) => {
  const startDate = new Date(2002 + Math.floor(index / 12), index % 12, 15);
  const endDate = new Date(startDate.getFullYear() + 2, Math.floor(Math.random() * 12), 1);

  return {
    id: (index + 1).toString(),
    numeroDocument: `D-${(index + 1).toString().padStart(7, '0')}`,
    intitule: [
      'Contrat de collaboration professionnelle',
      'Attestation d\'assurance',
      'Permis de conduire',
      'Carte grise',
      'Convention de transport'
    ][Math.floor(Math.random() * 5)],
    importePar: [
      'Jean Duppont',
      'Marie Martin',
      'Pierre Durant',
      'Sophie Bernard',
      'Lucas Petit'
    ][Math.floor(Math.random() * 5)],
    dateImportation: startDate.toISOString().split('T')[0],
    dateFin: endDate.toISOString().split('T')[0],
    type: fileTypes[Math.floor(Math.random() * fileTypes.length)],
    favorited: index % 2 === 0,
  };
});

export const DEFAULT_DOCUMENT_TABLE_HEAD: TableColumn[] = [
  { id: 'numeroDocument', label: 'N° document', type: 'text' },
  { id: 'intitule', label: 'Intitulé', type: 'text' },
  { id: 'importePar', label: 'Importé Par', type: 'text' },
  { id: 'dateImportation', label: 'Date d\'importation', type: 'date' },
  { id: 'dateFin', label: 'Date de fin', type: 'date' },
  { id: 'action', label: 'Action' },
];

export const STAFF_DOCUMENT_TABLE_HEAD: TableColumn[] = [
  { id: 'numeroDocument', label: 'N° document', type: 'text' },
  { id: 'intitule', label: 'Intitulé', type: 'text' },
  { id: 'dateImportation', label: 'Date d\'importation', type: 'date' },
  { id: 'dateFin', label: 'Date de fin', type: 'date' },
  { id: 'action', label: 'Action' },
];

export const INITIAL_DOCUMENT_DATA: IDocument = {
  id: '',
  numeroDocument: '',
  intitule: '',
  importePar: '',
  dateImportation: '',
  dateFin: '',
};



export const _suiviDocuments: ISuiviDocument[] = [...Array(4)].map((_, index) => {
  const startDate = new Date(2020 + Math.floor(index / 12), index % 12, 15)

  return {
    id: (index + 1).toString(),
    numeroSuivi: `S-${(index + 1).toString().padStart(7, "0")}`,
    type: [
      "Contrat de collaboration professionnelle",
      "Attestation d'assurance",
      "Permis de conduire",
      "Carte grise",
      "Convention de transport",
    ][Math.floor(Math.random() * 5)],
    dateImportation: startDate.toISOString().split("T")[0],
    numeroDocument: `D-${(index + 1).toString().padStart(7, "0")}`,
    observation: ["Ce bus facilite les déplacements urbains", "Il y avait un prob de clima dans la matinee"][
      Math.floor(Math.random() * 2)
    ],
  }
})

export const DEFAULT_SUIVI_DOCUMENT_TABLE_HEAD: TableColumn[] = [
  { id: "numeroSuivi", label: "N° de suivi", type: "text" },
  { id: "type", label: "Type", type: "text" },
  { id: "dateImportation", label: "Date", type: "date" },
  { id: "numeroDocument", label: "N° document", type: "text" },
  { id: "observation", label: "Observation", type: "text" },
]

export const _interventionReport: IDocument[] = [...Array(4)].map((_, index) => {
  const startDate = new Date(2002 + Math.floor(index / 12), index % 12, 15);
  const endDate = new Date(startDate.getFullYear() + 2, Math.floor(Math.random() * 12), 1);
  
  return {
    id: (index + 1).toString(),
    numeroDocument: `D-${(index + 1).toString().padStart(7, '0')}`,
    intitule: [
      'Ordre de réparation',
      'Rapport d\'intervention',
      'Fiche de diagnostic',
      'Devis de réparation',
      'Bon de livraison'
    ][Math.floor(Math.random() * 5)],
    importePar: [
      'Jean Duppont',
      'Marie Martin',
      'Pierre Durant',
      'Sophie Bernard',
      'Lucas Petit'
    ][Math.floor(Math.random() * 5)],
    dateImportation: startDate.toISOString().split('T')[0],
    dateFin: endDate.toISOString().split('T')[0],
  };
});

// Mock folders data with nested structure
export const createMockFolders = (): Folder[] => {
  // Create a copy of documents to distribute among folders
  const allDocuments = [..._documents]

  return [
    {
      id: "1",
      name: "Classroom",
      files: 3,
      documents: allDocuments.slice(0, 3),
      subFolders: [
        {
          id: "1-1",
          name: "Cours",
          files: 2,
          documents: allDocuments.slice(3, 5),
          parentId: "1",
          subFolders: []
        },
        {
          id: "1-2",
          name: "Examens",
          files: 2,
          documents: allDocuments.slice(5, 7),
          parentId: "1",
          subFolders: []
        },
      ],
    },
    {
      id: "2",
      name: "Word",
      files: 2,
      documents: allDocuments.slice(7, 9),
      subFolders: [],
    },
    {
      id: "3",
      name: "Outlook",
      files: 2,
      favorited: true,
      documents: allDocuments.slice(9, 11),
      subFolders: [
        { 
          id: "3-1",
          name: "Emails",
          files: 2,
          documents: allDocuments.slice(11, 13),
          parentId: "3",
          subFolders: []
        },
      ],
    },
    {
      id: "4",
      name: "Contracts",
      files: 2,
      documents: allDocuments.slice(13, 15),
      subFolders: [],
    },
    {
      id: "5",
      name: "Invoices",
      files: 2,
      documents: allDocuments.slice(15, 17),
      subFolders: [],
    },
  ]
}

