import { _noms, _prenoms } from "."
import { ScheduleData, DriverTimeSlot } from "../sections/chauffeur/planingChauffeur/types"
import { StatusColor } from "../sections/chauffeur/planingChauffeur/utils/schedule-utils"
import { TableColumn } from "../types/common"
import { _trajets } from "./_trajets"

const isTimeOverlapping = (
  start1: string,
  end1: string,
  start2: string,
  end2: string
) => {
  return start1 < end2 && end1 > start2
}

const generateTimeSlot = () => {
  const startHour = Math.floor(Math.random() * 22)
  const startMinute = Math.floor(Math.random() * 4) * 15

  let endHour = startHour
  let endMinute = startMinute

  const duration = 30 + Math.floor(Math.random() * 90)

  endMinute += duration
  if (endMinute >= 60) {
    endHour += Math.floor(endMinute / 60)
    endMinute %= 60
  }

  return {
    startHeure: startHour.toString().padStart(2, "0"),
    startMinute: startMinute.toString().padStart(2, "0"),
    endHeure: endHour.toString().padStart(2, "0"),
    endMinute: endMinute.toString().padStart(2, "0"),
  }
}

const absences = [
  {
    id: "1",
    driverId: "2",
    startDate: new Date(2024, 11, 11).toISOString().split("T")[0],
    endDate: new Date(2024, 11, 11).toISOString().split("T")[0],
    startHeure: "16",
    startMinute: "00",
    endHeure: "17",
    endMinute: "00",
    type: "absence" as const,
    justification: true,
    reason: "Absence"
  },
  {
    id: "2",
    driverId: "3",
    startDate: new Date(2024, 11, 11).toISOString().split("T")[0],
    endDate: new Date(2024, 11, 11).toISOString().split("T")[0],
    startHeure: "09",
    startMinute: "00",
    endHeure: "11",
    endMinute: "00",
    type: "vacation" as const,
    justification: true,
    reason: "Congés"
  },
  {
    id: "3",
    driverId: "5",
    startDate: new Date(2024, 11, 11).toISOString().split("T")[0],
    endDate: new Date(2024, 11, 11).toISOString().split("T")[0],
    startHeure: "14",
    startMinute: "00",
    endHeure: "15",
    endMinute: "00",
    type: "absence" as const,
    justification: false,
    reason: "Absence"
  }
]

export const mockScheduleData: ScheduleData = {
  drivers: [
    { id: "1", name: "Non Affecté", company: "", vehicleId: "", immatricule:"" },
    ...Array.from({ length: 10 }, (_, index) => ({
      id: (index + 2).toString(),
      name: `${_prenoms[index % 4]} ${_noms[index % 4]}`,
      company: ["Citadine SP", "TransUrban", "MetroRide"][Math.floor(Math.random() * 3)],
      vehicleId: Math.floor(1000000 + Math.random() * 9000000).toString(),
      immatricule:""
    })),
  ],
  timeSlots: Array.from({ length: 30 }, (_, index) => {
    const date = new Date(2024, 0, 1 + index)
    const formattedDate = date.toISOString().split("T")[0]
    const driverId = Math.floor(Math.random() * 11 + 1).toString()
    
    const timeSlot = generateTimeSlot()
    
    const hasOverlappingAbsence = absences.some(absence => 
      absence.driverId === driverId && 
      absence.startDate === formattedDate &&
      isTimeOverlapping(
        `${timeSlot.startHeure}:${timeSlot.startMinute}`,
        `${timeSlot.endHeure}:${timeSlot.endMinute}`,
        `${absence.startHeure}:${absence.startMinute}`,
        `${absence.endHeure}:${absence.endMinute}`
      )
    )

    if (hasOverlappingAbsence) {
      return null
    }

    return {
      id: (index + 1).toString(),
      driverId,
      vehicleId: ['AA-123-BB', 'BB-456-CC', 'CC-789-DD', 'DD-101-EE'][Math.floor(Math.random() * 4)],
      ...timeSlot,
      date: formattedDate,
      color: Object.values(StatusColor)[Math.floor(Math.random() * 4)],
      trajet: _trajets[index]
    }
  }).filter(Boolean) as DriverTimeSlot[],
  absences,
}



export const eventTypeOptions = [
  { label: "Trajet", value: "trajet" },
  { label: "Absence", value: "absence" }
]

export const companyOptions = [
  { label: "Citadine SP", value: "Citadine SP" },
  { label: "TransUrban", value: "TransUrban" },
  { label: "MetroRide", value: "MetroRide" },
]

export const absenceTypeOptions = [
  { label: "Absence", value: "absence" },
  { label: "Congés", value: "vacation" }
]

export const DRIVER_TABLE_COLUMNS : TableColumn[] =  [
  { id: "name", label: "Nom du chauffeur", type: "text" },
  { id: "company", label: "Marque", type: "text" },
  { id: "vehicleId", label: "ID du véhicule", type: "text" },
  { id: "eventType", label: "Type d'événement", type: "status", options: eventTypeOptions },
  { id: "startHeure", label: "Heure de début", type: "text" },
  { id: "endHeure", label: "Heure de fin", type: "text" },
  { id: "absenceType", label: "Type d'absence", type: "text" },
  { id: "absenceJustified", label: "Absence justifiée", type: "boolean" }
]