import {
    AutomationEvent,
    AutomationFrequency,
    DEFAULT_EMAIL_AUTOMATION_TABLE_HEAD,
    type IEmailAutomation,
  } from "@/shared/types/email-automation"
  import { _emailTemplates } from "./_email-templates"
  
  // Génération des données mock pour les automatisations d'email
  export const _emailAutomations: IEmailAutomation[] = [...Array(10)].map((_, index) => {
    // Sélectionner un modèle d'email aléatoire parmi ceux qui ne sont pas archivés
    const availableTemplates = _emailTemplates.filter((template) => !template.isArchive)
    const selectedTemplate = availableTemplates[index % availableTemplates.length]
  
    // Générer une date pour le dernier envoi (dans les 30 derniers jours)
    const lastSentDate = new Date()
    lastSentDate.setDate(lastSentDate.getDate() - Math.floor(Math.random() * 30))
  
    // Noms des règles d'automatisation
    const ruleNames = [
      "Notification fin de contrat",
      "Rappel réunion hebdomadaire",
      "Email de bienvenue",
      "Rappel formation sécurité",
      "Anniversaires du mois",
      "Rappel évaluation annuelle",
      "Notification congés",
      "Rappel mise à jour profil",
      "Information mensuelle",
      "Rappel événements",
    ]
  
    // Groupes de destinataires
    const groups = ["Tous les employés", "Service RH", "Service IT", "Direction", "Managers", "Nouveaux employés"]
  
    // Individus (exemples)
    const individuals = [
      "jean.dupont@example.com",
      "marie.martin@example.com",
      "paul.bernard@example.com",
      "sophie.petit@example.com",
      "thomas.durand@example.com",
    ]
  
    // Heures d'envoi
    const sendTimes = ["08:00", "09:00", "12:00", "14:00", "16:00", "18:00"]
  
    // Déterminer si c'est une fréquence ou un événement
    const isFrequency = Math.random() > 0.5
  
    // Fréquences disponibles
    const frequencies = [
      AutomationFrequency.QUOTIDIEN,
      AutomationFrequency.HEBDOMADAIRE,
      AutomationFrequency.MENSUEL,
      AutomationFrequency.ANNUEL,
    ]
  
    // Événements disponibles
    const events = [
      AutomationEvent.ANNIVERSAIRE_EMPLOYE,
      AutomationEvent.FIN_CONTRAT,
      AutomationEvent.RAPPEL_REUNION,
      AutomationEvent.AUTRE,
    ]
  
    // Déterminer si les destinataires sont des groupes ou des individus
    const isGroup = Math.random() > 0.3
  
    return {
      id: (index + 1).toString(),
      nom: ruleNames[index % ruleNames.length],
      templateId: selectedTemplate.id,
      templateTitre: selectedTemplate.titre,
      declencheur: isFrequency
        ? {
            type: "FREQUENCE",
            frequence: frequencies[index % frequencies.length],
          }
        : {
            type: "EVENEMENT",
            evenement: events[index % events.length],
          },
      destinataires: isGroup
        ? {
            type: "GROUPE",
            groupes: [groups[index % groups.length]],
          }
        : {
            type: "INDIVIDU",
            individus: [individuals[index % individuals.length]],
          },
      heureEnvoi: sendTimes[index % sendTimes.length],
      dernierEnvoi: Math.random() > 0.3 ? lastSentDate.toISOString() : undefined, // 70% ont un dernier envoi
      isArchive: Math.random() > 0.9, // 10% sont archivés
    }
  })
  
  export { DEFAULT_EMAIL_AUTOMATION_TABLE_HEAD }
  