import { DEFAULT_EMAIL_HISTORY_TABLE_HEAD, EmailStatus, type IEmailHistory } from "@/shared/types/email-history"
import { _emailTemplates } from "./_email-templates"

// Fonction pour générer des logs d'erreur
const generateErrorLog = (): string => {
  const errors = [
    `ERROR [${new Date().toISOString()}]: Failed to connect to SMTP server\nConnection timed out after 30000ms\nAttempting retry (1/3)...`,
    `ERROR [${new Date().toISOString()}]: Authentication failed\nInvalid credentials provided\nPlease check SMTP configuration`,
    `ERROR [${new Date().toISOString()}]: Recipient address rejected\nUser unknown in virtual alias table\nMessage could not be delivered`,
  ]

  return errors[Math.floor(Math.random() * errors.length)]
}

// Génération des données mock pour l'historique des emails
export const _emailHistory: IEmailHistory[] = [...Array(20)].map((_, index) => {
  // Sélectionner un modèle d'email aléatoire
  const selectedTemplate = _emailTemplates[index % _emailTemplates.length]

  // Générer une date d'envoi (dans les 60 derniers jours)
  const sendDate = new Date()
  sendDate.setDate(sendDate.getDate() - Math.floor(Math.random() * 60))

  // Statuts possibles
  const statuses = [EmailStatus.ENVOYE, EmailStatus.ECHEC, EmailStatus.PLANIFIE]

  // Sélectionner un statut
  const status = statuses[index % statuses.length]

  // Groupes de destinataires
  const recipientGroups = [
    "Tous les employés",
    "Service RH",
    "Service IT",
    "Direction",
    "Managers",
    "Nouveaux employés",
  ]

  // Individus (exemples)
  const individuals = [
    "jean.dupont@example.com",
    "marie.martin@example.com",
    "paul.bernard@example.com",
    "sophie.petit@example.com",
    "thomas.durand@example.com",
  ]

  // Déterminer si les destinataires sont des groupes ou des individus
  const isGroup = Math.random() > 0.5

  // Détails supplémentaires pour les emails envoyés
  const details =
    status === EmailStatus.ENVOYE
      ? `Email envoyé avec succès à ${Math.floor(Math.random() * 50) + 1} destinataires.`
      : undefined

  // Logs d'erreur pour les emails en échec
  const errorLogs = status === EmailStatus.ECHEC ? generateErrorLog() : undefined

  return {
    id: (index + 1).toString(),
    templateId: selectedTemplate.id,
    templateTitre: selectedTemplate.titre,
    dateEnvoi:
      status === EmailStatus.PLANIFIE
        ? new Date(sendDate.getTime() + 86400000 * Math.floor(Math.random() * 7)).toISOString() // Date future pour les planifiés
        : sendDate.toISOString(),
    destinataires: isGroup ? recipientGroups[index % recipientGroups.length] : individuals[index % individuals.length],
    status,
    details,
    logsErreur: errorLogs,
  }
})

export { DEFAULT_EMAIL_HISTORY_TABLE_HEAD }
