import {
    EmailTemplateCategory,
    type IEmailTemplate,
    DEFAULT_EMAIL_TEMPLATE_TABLE_HEAD,
  } from "@/shared/types/email-template"
  
  // Fonction pour générer du contenu HTML pour les modèles d'email
  const generateEmailContent = (index: number): string => {
    const contents = [
      `<div style="font-family: Arial, sans-serif; padding: 20px;">
        <h2 style="color: #2a3f54;">Notification de fin de contrat</h2>
        <p>Bonjour [NOM_EMPLOYE],</p>
        <p>Nous vous informons que votre contrat arrivera à échéance le [DATE_FIN_CONTRAT].</p>
        <p>Merci de prendre contact avec le service RH pour discuter des prochaines étapes.</p>
        <p>Cordialement,<br>Le Service RH</p>
      </div>`,
  
      `<div style="font-family: Arial, sans-serif; padding: 20px;">
        <h2 style="color: #2a3f54;">Invitation à la réunion mensuelle</h2>
        <p>Chers collaborateurs,</p>
        <p>Nous vous rappelons que la réunion mensuelle aura lieu le [DATE_REUNION] à [HEURE_REUNION] dans la salle [SALLE_REUNION].</p>
        <p>Ordre du jour :</p>
        <ul>
          <li>Bilan du mois précédent</li>
          <li>Objectifs du mois à venir</li>
          <li>Questions diverses</li>
        </ul>
        <p>Cordialement,<br>La Direction</p>
      </div>`,
  
      `<div style="font-family: Arial, sans-serif; padding: 20px;">
        <h2 style="color: #2a3f54;">Bienvenue dans l'entreprise</h2>
        <p>Bonjour [NOM_EMPLOYE],</p>
        <p>Nous sommes ravis de vous accueillir au sein de notre équipe à partir du [DATE_DEBUT].</p>
        <p>Vous trouverez ci-joint les informations nécessaires pour votre intégration.</p>
        <p>Cordialement,<br>Le Service RH</p>
      </div>`,
  
      `<div style="font-family: Arial, sans-serif; padding: 20px;">
        <h2 style="color: #2a3f54;">Rappel : Formation obligatoire</h2>
        <p>Bonjour [NOM_EMPLOYE],</p>
        <p>Nous vous rappelons que vous devez suivre la formation [NOM_FORMATION] avant le [DATE_LIMITE].</p>
        <p>Cette formation est obligatoire pour tous les employés de votre département.</p>
        <p>Cordialement,<br>Le Service Formation</p>
      </div>`,
  
      `<div style="font-family: Arial, sans-serif; padding: 20px;">
        <h2 style="color: #2a3f54;">Joyeux anniversaire !</h2>
        <p>Cher(e) [NOM_EMPLOYE],</p>
        <p>Toute l'équipe vous souhaite un joyeux anniversaire !</p>
        <p>Nous espérons que vous passerez une excellente journée.</p>
        <p>Cordialement,<br>L'équipe RH</p>
      </div>`,
    ]
  
    return contents[index % contents.length]
  }
  
  // Génération des données mock pour les modèles d'email
  export const _emailTemplates: IEmailTemplate[] = [...Array(15)].map((_, index) => {
    // Générer une date dans les 2 dernières années
    const creationDate = new Date()
    creationDate.setMonth(creationDate.getMonth() - Math.floor(Math.random() * 24))
  
    // Titres des modèles
    const titles = [
      "Notification de fin de contrat",
      "Invitation à la réunion mensuelle",
      "Bienvenue dans l'entreprise",
      "Rappel : Formation obligatoire",
      "Joyeux anniversaire",
      "Mise à jour des politiques internes",
      "Confirmation de congés",
      "Évaluation annuelle",
      "Changement d'horaires",
      "Invitation à un événement d'entreprise",
    ]
  
    // Descriptions des modèles
    const descriptions = [
      "Email envoyé automatiquement avant la fin d'un contrat",
      "Rappel pour la réunion mensuelle de l'équipe",
      "Email de bienvenue pour les nouveaux employés",
      "Rappel pour les formations obligatoires",
      "Email d'anniversaire automatique",
      "Information sur les mises à jour des politiques",
      "Confirmation des demandes de congés",
      "Notification pour l'évaluation annuelle",
      "Information sur les changements d'horaires",
      "Invitation aux événements d'entreprise",
    ]
  
    // Catégories des modèles
    const categories = [
      EmailTemplateCategory.NOTIFICATION_RH,
      EmailTemplateCategory.COMMUNICATION_INTERNE,
      EmailTemplateCategory.RAPPEL,
      EmailTemplateCategory.INFORMATION,
      EmailTemplateCategory.AUTRE,
    ]
  
    return {
      id: (index + 1).toString(),
      titre: titles[index % titles.length],
      description: descriptions[index % descriptions.length],
      categorie: categories[index % categories.length],
      contenu: generateEmailContent(index),
      dateCreation: creationDate.toISOString().split("T")[0],
      isArchive: Math.random() > 0.9, // 10% des modèles sont archivés
    }
  })
  
  export { DEFAULT_EMAIL_TEMPLATE_TABLE_HEAD }
  