// _lot.ts
import { ILot } from '@/shared/types/infrastructure';
import { TableColumn } from '../types/common';

export const DEFAULT_LOT_TABLE_HEAD: TableColumn[] = [
    { id: 'name', label: 'Nom', align: 'left' },
    { id: 'description', label: 'Description', align: 'left' },
    { id: 'createdAt', label: 'Créé le', align: 'left' },
    { id: 'updatedAt', label: 'Mis à jour le', align: 'left' },
];

export const INITIAL_LOT_DATA: ILot = {
    id: '',
    name: '',
    lotNumber: '',
    description: '',
    createdAt: new Date().toISOString().split('T')[0],
    updatedAt: new Date().toISOString().split('T')[0],
    department : [],
};

export const _lots: ILot[] = [
    {
        id: "1",
        name: 'Lot A1',
        lotNumber: 'A1001',
        description: 'Matériel informatique',
        createdAt: new Date().toISOString().split('T')[0],
        updatedAt: new Date().toISOString().split('T')[0],
        department : [],
    },
    {
        id: "2",
        name: 'Lot B2',
        lotNumber: 'B2002',
        description: 'Fournitures de bureau',
        createdAt: new Date().toISOString().split('T')[0],
        updatedAt: new Date().toISOString().split('T')[0],
        department : [],
    },
    {
        id: "3",
        name: 'Lot C3',
        lotNumber: 'C3003',
        description: 'Véhicules de service',
        createdAt: new Date().toISOString().split('T')[0],
        updatedAt: new Date().toISOString().split('T')[0],
        department : [],
    },
    {
        id: "4",
        name: 'Lot D4',
        lotNumber: 'D4004',
        description: 'Équipements de production',
        createdAt: new Date().toISOString().split('T')[0],
        updatedAt: new Date().toISOString().split('T')[0],
        department : [],
    },
    {
        id: "5",
        name: 'Lot E5',
        lotNumber: 'E5005',
        description: 'Mobilier de bureau',
        createdAt: new Date().toISOString().split('T')[0],
        updatedAt: new Date().toISOString().split('T')[0],
        department : [],
    },
    {
        id: "6",
        name: 'Lot F6',
        lotNumber: 'F6006',
        description: 'Systèmes de sécurité',
        createdAt: new Date().toISOString().split('T')[0],
        updatedAt: new Date().toISOString().split('T')[0],
        department : [],
    },
    {
        id: "7",
        name: 'Lot G7',
        lotNumber: 'G7007',
        description: 'Matériel de communication',
        createdAt: new Date().toISOString().split('T')[0],
        updatedAt: new Date().toISOString().split('T')[0],
        department : [],
    },
    {
        id: "8",
        name: 'Lot H8',
        lotNumber: 'H8008',
        description: 'Équipements de laboratoire',
        createdAt: new Date().toISOString().split('T')[0],
        updatedAt: new Date().toISOString().split('T')[0],
        department : [],
    },
    {
        id: "9",
        name: 'Lot I9',
        lotNumber: 'I9009',
        description: 'Ressources marketing',
        createdAt: new Date().toISOString().split('T')[0],
        updatedAt: new Date().toISOString().split('T')[0],
        department : [],
    },
    {
        id: "10",
        name: 'Lot J10',
        lotNumber: 'J1010',
        description: 'Stock de produits finis',
        createdAt: new Date().toISOString().split('T')[0],
        updatedAt: new Date().toISOString().split('T')[0],
        department : [],
    },
    {
        id: "11",
        name: 'Lot K11',
        lotNumber: 'K1111',
        description: 'Matériel de formation',
        createdAt: new Date().toISOString().split('T')[0],
        updatedAt: new Date().toISOString().split('T')[0],
        department : [],
    },
    {
        id: "12",
        name: 'Lot L12',
        lotNumber: 'L1212',
        description: 'Équipements de maintenance',
        createdAt: new Date().toISOString().split('T')[0],
        updatedAt: new Date().toISOString().split('T')[0],
        department : [],
    },
    {
        id: "13",
        name: 'Lot M13',
        lotNumber: 'M1313',
        description: 'Ressources événementielles',
        createdAt: new Date().toISOString().split('T')[0],
        updatedAt: new Date().toISOString().split('T')[0],
        department : [],
    }
];