import { IPreparationCircuit } from "../types/circuit";
import { CircuitMap } from "../types/Maps";
import { StatusColor } from "../sections/chauffeur/planingChauffeur/utils/schedule-utils";
import { _CHAUFFEURS } from "./_absenceDriver";
import { TableColumn } from "../types/common";
import { MOCK_ADDRESSES } from ".";

export const _circuitsPreparation = [...Array(55)].map((_, index) => {
  const startDate = new Date(2002 + Math.floor(index / 12), index % 12, 15);
  const endDate = new Date(startDate.getFullYear() + 2, Math.floor(Math.random() * 12), 1);
  const circuitCode = `CIR-2024-${String.fromCharCode(65 + (index % 26))}${String.fromCharCode(65 + (Math.floor(index / 26)))}`;
  const mockAddress = MOCK_ADDRESSES[index % 4];
  
  return {
    id: (index + 1).toString(),
    codeCircuit: circuitCode,
    intitule: `Ligne ${['Nord', 'Sud', 'Est', 'Ouest'][index % 4]}`,
    dateDebut: startDate.toISOString().split('T')[0],
    dateFin: endDate.toISOString().split('T')[0],
    etablissement: ['Les Champs', 'La Colline', 'Le Rivage', 'La Forêt'][index % 4],
    adresseEtablissement: mockAddress,
    usagers: [_CHAUFFEURS[index % 4]],
  };
});

export const DEFAULT_CIRCUIT_PREPARATION_TABLE_HEAD : TableColumn[] = [
  { id: 'id', label: 'N° circuit', type: 'text',align: 'center' },
  { id: 'codeCircuit', label: 'Code circuit', type: 'text',align: 'left' },
  { id: 'intitule', label: 'Intitulé', type: 'text',align: 'left' },
  { id: 'dateDebut', label: 'A partir du', type: 'date',align: 'center' },
  { id: 'dateFin', label: 'Fin de circuit', type: 'date',align: 'center' },
  { id: 'etablissement', label: 'Établissement', type: 'text',align: 'left' },
  { id: '', label: 'Action' },
];

export const INITIAL_CIRCUIT_PREPARATION_DATA: IPreparationCircuit = {
  id: '',
  codeCircuit: '',
  intitule: '',
  dateDebut: '',
  dateFin: '',
  etablissement: '',
  usagers: [],
  adresseEtablissement:{
    address: '',
    lat: 0,
    lng: 0,
    city: '',
    postalCode: '',
    country: '',
    formattedAddress: ''
  },
};


export const _mockRoutes: CircuitMap[] = [
    {
      id: "route-1",
      name: "Route Armand Duplantis",
      color : StatusColor.PRIMARY,
      startPoint: {
        position: { lat: 43.2963, lng: 5.3796 },
        title: "ARMAND duplantis",
      },
      endPoint: {
        position: { lat: 43.2967, lng: 5.379 },
        title: "École Clair",
      },
      path: [
        { lat: 43.2963, lng: 5.3792 },
        { lat: 43.2967, lng: 5.3792 },
        { lat: 43.2967, lng: 5.379 },
      ],
      users: [
        {
          position: { lat: 43.2963, lng: 5.3792 },
          title: "Anna Leblanc",
        },
        {
          position: { lat: 43.2967, lng: 5.3792 },
          title: "Marc Dupont",
        },
      ],
    },
    {
      id: "route-2",
      name: "Route Centre Ville",
      color : StatusColor.WARNING,
      startPoint: {
        position: { lat: 43.296, lng: 5.378 },
        title: "Place Centrale",
      },
      endPoint: {
        position: { lat: 43.2967, lng: 5.379 },
        title: "École Clair",
      },
      path: [
        { lat: 43.2968, lng: 5.3787 },
        { lat: 43.2967, lng: 5.379 },
      ],
      users: [
        {
          position: { lat: 43.2968, lng: 5.3787 },
          title: "Sophie Martin",
        },
      ],
      tolls: [
        {
          position: { lat: 43.2966, lng: 5.3783 },
          title: "toll1",
        },
      ],
    },
    {
      id: "route-3",
      name: "Route Vieux Port",
      color: StatusColor.SUCCESS,
      startPoint: {
        position: { lat: 43.2950, lng: 5.3770 },
        title: "Vieux Port",
      },
      endPoint: {
        position: { lat: 43.2967, lng: 5.379 },
        title: "École Clair",
      },
      path: [
        { lat: 43.2952, lng: 5.3768 },
        { lat: 43.2954, lng: 5.3765 },
        { lat: 43.2960, lng: 5.3775 },
        { lat: 43.2967, lng: 5.379 },
      ],
      users: [
        {
          position: { lat: 43.2952, lng: 5.3768 },
          title: "Jean Moreau",
        },
        {
          position: { lat: 43.2960, lng: 5.3775 },
          title: "Camille Dubois",
        },
      ],
      tolls: [
        {
          position: { lat: 43.2954, lng: 5.3765 },
          title: "toll2",
        },
      ],
    },
    {
      id: "route-4",
      name: "KmAVide",
      color : StatusColor.GREY,
      path: [
        { lat: 43.296, lng: 5.378 },
        { lat: 43.2964, lng: 5.3788 },
        { lat: 43.2967, lng: 5.379 }, 
      ],
    },
    {
      id: "route-5",
      name: "KmAVide",
      color : StatusColor.GREY,
      path: [
        { lat: 43.296, lng: 5.378 },
        { lat: 43.2966, lng: 5.3783 },
        { lat: 43.2968, lng: 5.3787 },
      ],
    },
    {
      id: "route-6",
      name: "KmAVide",
      color : StatusColor.GREY,
      path: [
        { lat: 43.2950, lng: 5.3770 },
        { lat: 43.2952, lng: 5.3768 },
      ],
    },
    {
      id: "route-7",
      name: "KmAVide",
      color : StatusColor.GREY,
      path: [
        { lat: 43.2963, lng: 5.3796 },
        { lat: 43.2963, lng: 5.3792 },
      ],
    },
]
export const _mockCircuitRoutes: CircuitMap[] = [
  {
    id: "route-1",
    name: "Route Armand Duplantis",
    color : StatusColor.PRIMARY,
    startPoint: {
      position: { lat: 43.2963, lng: 5.3796 },
      title: "ARMAND duplantis",
    },
    endPoint: {
      position: { lat: 43.2967, lng: 5.379 },
      title: "École Clair",
    },
    path: [
      { lat: 43.2963, lng: 5.3796 },
      { lat: 43.2963, lng: 5.3792 },
      { lat: 43.2967, lng: 5.3792 },
      { lat: 43.2967, lng: 5.379 },
    ],
    users: [
      {
        position: { lat: 43.2963, lng: 5.3792 },
        title: "Anna Leblanc",
      },
      {
        position: { lat: 43.2967, lng: 5.3792 },
        title: "Marc Dupont",
      },
    ],
  },
  {
    id: "route-2",
    name: "Route Centre Ville",
    color : StatusColor.WARNING,
    startPoint: {
      position: { lat: 43.296, lng: 5.378 },
      title: "Place Centrale",
    },
    endPoint: {
      position: { lat: 43.2967, lng: 5.379 },
      title: "École Clair",
    },
    path: [
      { lat: 43.296, lng: 5.378 },
      { lat: 43.2966, lng: 5.3783 },
      { lat: 43.2968, lng: 5.3787 },
      { lat: 43.2967, lng: 5.379 },
    ],
    users: [
      {
        position: { lat: 43.2968, lng: 5.3787 },
        title: "Sophie Martin",
      },
    ],
    tolls: [
      {
        position: { lat: 43.2966, lng: 5.3783 },
        title: "toll1",
      },
    ],
  },
  {
    id: "route-3",
    name: "Route Vieux Port",
    color: StatusColor.SUCCESS,
    startPoint: {
      position: { lat: 43.2950, lng: 5.3770 },
      title: "Vieux Port",
    },
    endPoint: {
      position: { lat: 43.2967, lng: 5.379 },
      title: "École Clair",
    },
    path: [
      { lat: 43.2950, lng: 5.3770 },
      { lat: 43.2952, lng: 5.3768 },
      { lat: 43.2954, lng: 5.3765 },
      { lat: 43.2960, lng: 5.3775 },
      { lat: 43.2967, lng: 5.379 },
    ],
    users: [
      {
        position: { lat: 43.2952, lng: 5.3768 },
        title: "Jean Moreau",
      },
      {
        position: { lat: 43.2960, lng: 5.3775 },
        title: "Camille Dubois",
      },
    ],
    tolls: [
      {
        position: { lat: 43.2954, lng: 5.3765 },
        title: "toll2",
      },
    ],
  },
]
export const _mockTripRoutes: CircuitMap[] = [
  {
    id: "route-1",
    name: "Route Armand Duplantis",
    color : StatusColor.PRIMARY,
    startPoint: {
      position: { lat: 43.2963, lng: 5.3794 },
      title: "ARMAND duplantis",
    },
    endPoint: {
      position: { lat: 43.2967, lng: 5.379 },
      title: "École Clair",
    },
    path: [
      { lat: 43.2963, lng: 5.3794 },
      { lat: 43.2963, lng: 5.3792 },
      { lat: 43.2967, lng: 5.3792 },
      { lat: 43.2967, lng: 5.379 },
    ],
  },
]

export const _mockPassengersRoutes: CircuitMap[] = [
  {
    id: "route-1",
    name: "Route Armand Duplantis",
    color : StatusColor.PRIMARY,
    users: [
      {
        position: { lat: 43.2963, lng: 5.3792 },
        title: "Anna Leblanc",
      },
      {
        position: { lat: 43.2967, lng: 5.3792 },
        title: "Marc Dupont",
      },
    ],
  },
  {
    id: "route-2",
    name: "Route Centre Ville",
    color : StatusColor.WARNING,
    users: [
      {
        position: { lat: 43.2968, lng: 5.3787 },
        title: "Sophie Martin",
      },
    ],
  },
]
  
