import { TableColumn } from "../types/common"
import { IRouteTracking, RouteStatut } from "../types/suivi-trajet"
import { TypeTrajet } from "../types/trajet"

export const _STATUT_ROUTE_OPTIONS = [
  { value: RouteStatut.Affecte, label: "Affecté" },
  { value: RouteStatut.NonAffecte, label: "Non Affecté" },
]

export const getStatutLabel = (status: string): string => {
  const statusObj = _STATUT_ROUTE_OPTIONS.find((s) => s.value === status)
  return statusObj ? statusObj.label : "Inconnu"
}

export const _routeTracking = [...Array(50)].map((_, index) => {
    const trajetDate = new Date(2024, Math.floor(index % 12), Math.floor((index % 28) + 1));
    const chauffeurNames = ["Ahmed Benomar", "Khalid Larbi", "Sara Amrani", "Hassan Moussa"];
    const vehicleTypes = ["Bus", "Mini-Bus", "Berline", "vehicule"];
    const joursTrajet = ["Lun-Mar 18h", "Mar 17h", "Jeu-Ven 18h", "Mer-Ven 17h"][index % 4];
    const randomValue = Math.random()

  return {
    id: (index + 1).toString(),
    dateDebut: trajetDate.toISOString().split("T")[0],
    intitule: joursTrajet,
    sensAR: index < 2  ? "Aller" : "Retour",
    numeroUsagers: (index + 1).toString().padStart(4, '0'),
    statut: index === 0 ? RouteStatut.Affecte : RouteStatut.NonAffecte,
    chauffeur: index % 2 === 0 ? chauffeurNames[index % chauffeurNames.length] : "Non Affecté",
    etablissement: "École Bellevue",
    vehicule: vehicleTypes[index % vehicleTypes.length],
    typeTrajet: randomValue < 0.4  ? TypeTrajet.Normal : TypeTrajet.personnalise,
    isActive: randomValue < 0.3,
  }
})

export const DEFAULT_ROUTE_TRACKING_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N° trajet", type: "text", align: "center",width: 80 },
  { id: "dateDebut", label: "Date de début", type: "date", align: "center" },
  { id: "intitule", label: "Intitulé", type: "text", align: "left" },
  { id: "sensAR", label: "Sens", type: "text", align: "left" },
  { id: "numeroUsagers", label: "N° Usagers", type: "text", align: "left" },
  { id: "statut", label: "Statut", type: "status", align: "left" },
  { id: "chauffeur", label: "Chauffeur", type: "text", align: "left" },
  { id: "etablissement", label: "Établissement", type: "text", align: "left" },
  { id: "vehicule", label: "Véhicule", type: "text", align: "left" },
  { id: "typeTrajet", label: "Type", type: "text", align: "left" },
  { id: 'isActive', label: 'Active', type: 'boolean', align: 'center' },
  { id: '', label: 'Action' },
]

export const INITIAL_ROUTE_TRACKING_DATA: IRouteTracking = {
    id: "",
    dateDebut: '',
    intitule: "",
    sensAR: "",
    numeroUsagers: "",
    statut: RouteStatut.NonAffecte,
    chauffeur: "",
    etablissement: "",
    vehicule: "",
    typeTrajet: "",
    isActive: false,
  }
  
