import { CalendarEvent } from "@/hooks/use-calendar";
import { _noms, _prenoms } from ".";
import { getBgColor, StatusColor } from "../sections/chauffeur/planingChauffeur/utils/schedule-utils";
import { TableColumn } from "../types/common"
import { IFileImport, IVacance, RegionType, VacationType, ZoneType } from "../types/vacance"



const ETABLISSEMENTS = [
    "École la lune",
    "L'Élégance Bistro",
    "Collège Saint-Michel",
    "Lycée International"
  ]
  const getRandomZone = (): ZoneType => {
    const zoneValues = Object.values(ZoneType)
    const randomIndex = Math.floor(Math.random() * zoneValues.length)
    return zoneValues[randomIndex]
  }
  export const _vacances: IVacance[] = [...Array(25)].map((_, index) => {
    const month = index % 12
    const startDay = Math.floor(Math.random() * 15) + 1
    const duration = Math.floor(Math.random() * 10) + 5  
    const startDate = new Date(2025, month, startDay)
    const endDate = new Date(2025, month, startDay + duration)
  
    const vacance: IVacance = {
      id: (index + 1).toString(),
      numeroPeriode: `${(index + 1).toString().padStart(7, "0")}`,
      etablissement: ETABLISSEMENTS[index % ETABLISSEMENTS.length],
      zone: getRandomZone(),
      region: Object.values(RegionType)[index % 3],
      departement: "Département " + ((index % 5) + 1),
      dateDebut: startDate.toISOString().split("T")[0],
      dateFin: endDate.toISOString().split("T")[0],
      type: Object.values(VacationType)[index % Object.keys(VacationType).length],
      isActive: Math.random() < 0.6,
    }
    return vacance
  })
  
  export const DEFAULT_VACANCES_TABLE_HEAD: TableColumn[] = [
    { id: "numeroPeriode", label: "N° période", type: "text" },
    { id: "zone", label: "Zone scolaire", type: "status" },
    { id: "departement", label: "Département", type: "text" },
    { id: "dateDebut", label: "Date de début", type: "date" },
    { id: "dateFin", label: "Date de fin", type: "date" },
    { id: "type", label: "Type", type: "text" },
    { id: 'isActive', label: 'Active', type: 'boolean', align: 'left' },
    { id: "", label: "Action" }
  ]
  
  export const INITIAL_VACANCES_DATA: IVacance = {
    id: "",
    numeroPeriode: "",
    etablissement: "",
    zone: ZoneType.A,
    region: "",
    departement: "",
    dateDebut: "",
    dateFin: "",
    type: VacationType.NOEL,
    isActive: true,
  }

  export const ZoneColors = {
    [ZoneType.A]: StatusColor.ERROR,
    [ZoneType.B]: StatusColor.INFO,
    [ZoneType.C]: StatusColor.WARNING,
  }

  export const getVacancePeriods = (vacances: IVacance[]): CalendarEvent[] => {
    return vacances.map((vacance) => ({
      id: vacance.id,
      startDate: new Date(vacance.dateDebut),
      endDate: new Date(vacance.dateFin),
      label: vacance.type,
      color: ZoneColors[vacance.zone],
      bgColor: getBgColor(ZoneColors[vacance.zone]),
    }))
  }


  export const _vacationFileImportHeaders : TableColumn[] = [
    { id: "fileName", label: "Nom du fichier", type: "text" },
    { id: "importDate", label: "Date d'importation", type: "date"},
    { id: "importedBy", label: "Par", type: "text",align:"left" },
    { id: "", label: "Action" }
  ]
  
  export const _vacationFileImportData = [...Array(30)].map((_, index) => {
    const importDate = new Date(2002 + Math.floor(index / 12), index % 12, 15);
    return {
      id: (index + 1).toString(),
      fileName: `filName_${(index + 1).toString().padStart(3, "0")}`,
      importDate: importDate.toISOString(),
      importedBy:  `${_prenoms[index % 4]} ${_noms[index % 4]}`,
    }
  })
  
  export const DEFAULT_VACATION_FILE_IMPORT : IFileImport = {
    id: "",
    fileName: "",
    importDate: "",
    importedBy: "",
  }
  
  export const DEFAULT_ZONES = [
    { id: "zone-a", name: "Zone A", vacations: [] },
    { id: "zone-b", name: "Zone B", vacations: [] },
    { id: "zone-c", name: "Zone C", vacations: [] },
  ]