import { IEmployee } from "@/shared/types/flottes/employee"
import { _noms, _petrolier, _prenoms, AGENCY, generateDateRange, generatePhoneNumber, generateStartDate, getDepartement, IMMATRICULATIONS } from ".."
import { format, subDays } from "date-fns";
import { Consumption } from "@/shared/types/flottes/consumption";
import { TableColumn } from "@/shared/types/common";
const ABNORMAL_REASONS = [
  "Consommation excessive",
  "Prise de carburant trop fréquente",
  "Volume inhabituel pour ce véhicule",
  "Station service non autorisée",
]

export const createMockEmployee = (index: number): IEmployee => {
    return {
      id: `EMP${index + 1}`,
      gender: index % 2 === 0 ? "M" : "F",
      firstName: _prenoms[index % _prenoms.length],
      lastName: _noms[index % _noms.length],
      circuit: `Circuit ${index + 1}`,
      address: `${index + 1} Rue de la Paix`,
      zipCode: `7500${index % 10}`,
      city: AGENCY[index % AGENCY.length],
      phone: generatePhoneNumber("+33"),
      email: `${_prenoms[index % _prenoms.length].toLowerCase()}.${_noms[index % _noms.length].toLowerCase()}@example.com`,
      birthdate: format(subDays(new Date(), 10000 + index * 100), "yyyy-MM-dd"),
      department: getDepartement(index),
      activity: `Activity ${(index % 3) + 1}`,
      lastCardNumber: `CARD${1000 + index}`,
      lastTanker: _petrolier[index % _petrolier.length],
      dateOfEntry: format(subDays(new Date(), 1000 + index * 10), "yyyy-MM-dd"),
      fuelTypeCard: index % 2 === 0 ? "Diesel" : "Essence",
      vehicule: IMMATRICULATIONS[index % IMMATRICULATIONS.length],
      fuelVolume: 50 + index * 2,
      agencyCode: `AG${index % 10}`,
      fuelCard: null,
      consumptions: null,
      geolocData: null,
      lastNameFirstName: `${_noms[index % _noms.length]} ${_prenoms[index % _prenoms.length]}`,
      errors: "",
      dateImported: format(subDays(new Date(), index), "yyyy-MM-dd"),
      totalEmailsSent: index,
      totalKilometersTraveled: 1000 + index * 100,
      totalFuelCost: 500 + index * 50,
      carRegistration: IMMATRICULATIONS[index % IMMATRICULATIONS.length],
      emailHistory: null,
      transcolaire: null,
      correctData: true,
    }
  }

  export const _consumptionMockList: Consumption[] = [...Array(20)].map((_, index) => {
    const isNormal = index % 3 !== 0
  
    return {
      id: (index + 1).toString(),
      employe: createMockEmployee(index),
      tanker: _petrolier[index % _petrolier.length],
      date: generateStartDate(index),
      product: index % 2 === 0 ? "Diesel" : "Essence",
      quantity: 40 + index * 1.5,
      totalAmount: (40 + index * 1.5) * (1.8 + index * 0.02),
      puTTC: 1.8 + index * 0.02,
      zipCode: `7500${index % 10}`,
      city: AGENCY[index % AGENCY.length],
      normalConsumption: isNormal,
      fuelCardNumber: `CARD${1000 + index}`,
      causes: isNormal ? undefined : ABNORMAL_REASONS[index % ABNORMAL_REASONS.length],
      observation: isNormal ? undefined : `Observation ${index}`,
      sendMail: !isNormal,
      justification: isNormal ? undefined : `Justification ${index}`,
      managed: index % 4 === 0,
    }
  })

  export const INITIAL_CONSUMPTION_DATA: Consumption = {
    id: "",
    employe: {
      id: "",
      gender: "",
      firstName: "",
      lastName: "",
      circuit: "",
      address: "",
      zipCode: "",
      city: "",
      phone: "",
      email: "",
      birthdate: "",
      department: "",
      activity: "",
      lastCardNumber: "",
      lastTanker: "",
      dateOfEntry: "",
      fuelTypeCard: "",
      vehicule: "",
      fuelVolume: 0,
      agencyCode: "",
      fuelCard: null,
      consumptions: null,
      geolocData: null,
      lastNameFirstName: null,
      errors: "",
      dateImported: "",
      totalEmailsSent: 0,
      totalKilometersTraveled: 0,
      totalFuelCost: 0,
      carRegistration: "",
      emailHistory: null,
      transcolaire: null,
      correctData: true,
    },
    tanker: "",
    date: "",
    product: "",
    quantity: 0,
    totalAmount: 0,
    puTTC: 0,
    zipCode: "",
    city: "",
    normalConsumption: true,
    fuelCardNumber: "",
    sendMail: false,
    managed: false,
  }

  export const CONSUMPTION_TABLE_HEAD: TableColumn[] = [
    { id: "firstName", label: "Prénom", type: "text" },
    { id: "lastName", label: "Nom", type: "text" },
    { id: "vehicule", label: "Véhicule", type: "text" },
    { id: "tanker", label: "Pétrolier", type: "text" },
    { id: "phone", label: "Téléphone", type: "text" },
    { id: 'department', label: 'Département', type: 'text' },
    { id: 'date', label: 'Date', type: 'text' },
    { id: "fuelVolume", label: "Volume carburant", type: "text", width: 150 },
    { id: "totalAmount", label: "Montant des transactions", type: "text", width: 150 },
  ]
  
  export const ALL_CONSUMPTIONS_TABLE_HEAD: TableColumn[] = [
    { id: 'employe', label: 'Chauffeur', type: 'text' },
    { id: 'fuelCardNumber', label: 'Carte carburant', type: 'text' },
    { id: 'tanker', label: 'Pétrolier', type: 'text' },
    { id: 'date', label: 'Date', type: 'date' },
    { id: 'department', label: 'Département', type: 'text' },
    { id: 'quantity', label: 'Quantité', type: 'number' },
    { id: 'puTTC', label: 'Prix unitaire', type: 'number' },
    { id: 'totalAmount', label: 'Total', type: 'number' },
    { id: 'statut', label: 'Statut', type: 'text' },
    { id: 'product', label: 'Produit', type: 'text' },
    { id: 'zipCode', label: 'Code postal', type: 'text' },
    { id: 'city', label: 'Ville', type: 'text' },
  ];
  