import type { TableColumn } from "@/shared/types/common"
import { InterventionTab, ITypeReparation, type IIntervention } from "@/shared/types/flottes/intervention"

export const _TYPES_INTERVENTION = ["Mécanique", "Révision", "Entretien", "Carrosserie", "Électrique", "Pneumatique"]
export const _STATUTS = ["Réparation en cours", "En attente", "Terminé", "Annulé", "Planifié"]
export const _OBSERVATIONS = [
  "Glace verte",
  "Ampoules",
  "Freins",
  "Moteur",
  "Transmission",
  "Batterie",
  "Climatisation",
]
export const _REPARATEURS = ["Jean Jacques", "Marie Dupont", "Pierre Martin", "Sophie Leroy", "Thomas Dubois"]
export const _FOURNISSEURS = ["AutoPlus", "TurboParts", "MecaPro"]

export const _OPTION_STATUT = [
  { value: InterventionTab.EnCours, label: "Réparation en cours" },
  { value: InterventionTab.EnAttente, label: "En attente" },
  { value: InterventionTab.Cloture, label: "Cloture" },
]

export const _interventions: IIntervention[] = [...Array(40)].map((_, i) => {
  const numeroDossier = `${(i + 1).toString().padStart(7, "0")}`
  const dateIntervention = new Date(2025, Math.floor(i / 10), 15 + (i % 28)).toISOString().split("T")[0]
  const dateDebutImmo = dateIntervention
  const dateFinImmo = new Date(2025, Math.floor(i / 10), 15 + (i % 28) + 1 + Math.floor(Math.random() * 5))
    .toISOString()
    .split("T")[0]

  const kilometrage = `${160 + Math.floor(Math.random() * 40)}`

  return {
    id: numeroDossier,
    vehiculeConcerne: "Société",
    typeIntervention: _TYPES_INTERVENTION[i % _TYPES_INTERVENTION.length],
    dateIntervention: dateIntervention,
    statut: _OPTION_STATUT[i % 3].value,
    kilometrageReleve: kilometrage,
    montantDevis: `${i} 000 000`,
    coutHT: `${i}00`,
    coutTTC: `${i-10}00`,
    acceptationDevis: "Oui",
    observations: _OBSERVATIONS[i % _OBSERVATIONS.length],
    garantie: "Oui",
    dateDebutImmobilisation: dateDebutImmo,
    dateFinImmobilisation: dateFinImmo,
    reparateur: _REPARATEURS[i % _REPARATEURS.length],
    factureRecue: "Oui",
    conducteurPrevenu: "Oui",
    le: dateIntervention,
    fournisseur: _FOURNISSEURS[i % _FOURNISSEURS.length],
    isActive:Math.random() < 0.6,
    client: "",
    societe: "",
  }
})

export const DEFAULT_INTERVENTION_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N°", type: "text" },
  { id: "vehiculeConcerne", label: "Véhicule", type: "text" },
  { id: "typeIntervention", label: "Type", type: "text" },
  { id: "dateIntervention", label: "Date", type: "date" },
  { id: "kilometrageReleve", label: "Kilométrage relevé", type: "text" },
  { id: "montantDevis", label: "Montant du devis", type: "text" },
  { id: "acceptationDevis", label: "Accepte", type: "text", align: "center" },
  { id: "coutHT", label: "Coût HT", type: "text" },
  { id: "coutTTC", label: "Coût TTC", type: "text" },
  { id: "garantie", label: "Sous garantie", type: "text", align: "center" },
  { id: "dateDebutImmobilisation", label: "Début d'immobilisation", type: "date" },
  { id: "statut", label: "Statut", type: "statut" },
  { id: "dateFinImmobilisation", label: "Fin d'immobilisation", type: "date" },
  { id: "reparateur", label: "Réparateur", type: "text" },
  { id: "factureRecue", label: "Facture reçue", type: "text", align: "center" },
  { id: "conducteurPrevenu", label: "Conducteur prévenu", type: "text", align: "center" },
  { id: "le", label: "Le", type: "date", align: "center" },
  { id: "fournisseur", label: "Fournisseur", type: "text", align: "center" },
  { id: 'isActive', label: 'Active', type: 'boolean',align: 'center' },
  { id: "", label: "Action" },
]

export const INITIAL_INTERVENTION_DATA: IIntervention = {
  id: "",
  vehiculeConcerne: "",
  typeIntervention: "",
  dateIntervention: "",
  statut: InterventionTab.EnAttente,
  kilometrageReleve: "",
  montantDevis: "",
  acceptationDevis: "",
  coutTTC: "",
  coutHT: "",
  observations: "",
  garantie: "",
  dateDebutImmobilisation: "",
  dateFinImmobilisation: "",
  reparateur: "",
  factureRecue: "",
  conducteurPrevenu: "",
  le: "",
  fournisseur: "",
  isActive: true,
  client: "",
  societe: "",
}

// reparation types
export const _TypesReparations: ITypeReparation[] = [...Array(15)].map((_, i) => {

  return {
    id: (i + 1).toString(),
    intitule: _TYPES_INTERVENTION[i % _TYPES_INTERVENTION.length],
    observation: i % 3 === 0 ? "Observation importante" : "",
    isActive: Math.random() < 0.8,
  }
})

export const DEFAULT_TYPE_REPARATION_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N°", type: "text" },
  { id: "intitule", label: "Type de Réparation", type: "text" },
  { id: "isActive", label: "Actif", type: "boolean", align: "center" },
  { id: "", label: "Action" },
]

export const INITIAL_TYPE_REPARATION_DATA: ITypeReparation = {
  id: "",
  intitule: "",
  isActive: true,
}
