import type { TableColumn } from "@/shared/types/common";
import { ISupplierType } from "@/shared/types/flottes/vehicule";

export const _supplierTypes: ISupplierType[] = [
  {
    id: "1",
    intitule: "EuroCar",
    isActive: true,
  },
  {
    id: "2",
    intitule: "AutoLoc",
    isActive: true,
  },
  {
    id: "3",
    intitule: "RentExpress",
    isActive: true,
  },
  {
    id: "4",
    intitule: "MobilityPlus",
    isActive: true,
  },
];

export const DEFAULT_SUPPLIER_TYPE_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N°", type: "text" },
  { id: "intitule", label: "Type de Fournisseur", type: "text" },
  { id: "isActive", label: "Actif", type: "boolean", align: "center" },
  { id: "", label: "Action" },
];

export const INITIAL_SUPPLIER_TYPE_DATA: ISupplierType = {
  id: "",
  intitule: "",
  observation:"",
  isActive: true,
}; 