const baseEndpoint = "/api/absence"
const userEndpoint = "/api/user"

export const endpoints = {
  Absence: {
    getAbsences: baseEndpoint  + '/getPassengersAbsences', 
    getAbsenceById: (id: string) => baseEndpoint+`/${id}`, 
    updateAbsence: (id: number) => baseEndpoint + `/${id}`,
    createAbsence: baseEndpoint + '/createPassengerAbsence',
    exportAbsence: baseEndpoint + '/export',
    downloadExport: baseEndpoint + '/export/download',
    // Agent absence export endpoints
    exportAgentAbsences: baseEndpoint + '/export_absence',
    downloadAgentAbsenceExport: baseEndpoint + '/export'
  },
  User: {
    searchPassengers: userEndpoint + '/passenger/search',
  }
};