const endpointPrefix = "/api/admin"

export const establishmentEndpoints = {
  getEstablishmentsPage: endpointPrefix + "/establishments/page",
  toggleActivation: (id: string, active: boolean) => endpointPrefix + `/establishments/toggle-activation/${id}?active=${active}`,
  getEstablishmentById: (id: string) => endpointPrefix + `/establishments/${id}`,
  getAllEstablishmentNamesAndIds: endpointPrefix + "/establishments/all-names-ids",
  createEstablishment: endpointPrefix + "/establishments",
  updateEstablishment: (id: string) => endpointPrefix + `/establishments/update/${id}`,
  startExportFiltredEstablishments: endpointPrefix + "/establishments/startCsvExport",
};