const endpointPrefix = "/api/document";

export const documentEndpoints = {
  Folder: {
    create: endpointPrefix + "/folders/create",
    rename: (folderId: number, newName: string, ownerUuid : string) =>
  `${endpointPrefix}/folders/rename/${folderId}?newName=${encodeURIComponent(newName)}&ownerUuid=${ownerUuid}`,
    delete: (folderId: number, ownerUuid : string) => `${endpointPrefix}/folders/delete/${folderId}?ownerUuid=${ownerUuid}`,
    getById: (folderId: number) => `${endpointPrefix}/folders/${folderId}`,
    getUserRootFolders: (ownerUuid : string) => `${endpointPrefix}/folders/root/${ownerUuid}`,
    getUserAllFolders: (ownerUuid : string) => `${endpointPrefix}/folders/all/${ownerUuid}`,
    move: endpointPrefix + "/folders/move",
    bulkMove: endpointPrefix + "/folders/bulk/move",
    bulkDelete: endpointPrefix + "/folders/bulk/delete",
    bulkShare: endpointPrefix + "/folders/bulk/share",
    share: endpointPrefix + "/folders/share",
    favorite: (folderId: number, ownerUuid : string) => `${endpointPrefix}/folders/favorite/${folderId}?ownerUuid=${ownerUuid}`,
    unfavorite: (folderId: number, ownerUuid : string) => `${endpointPrefix}/folders/cancel-favorite/${folderId}?ownerUuid=${ownerUuid}`,
    getFavorites: (ownerUuid : string) => `${endpointPrefix}/folders/favorites/${ownerUuid}`,
    search: endpointPrefix + "/folders/search",
    advancedSearch: endpointPrefix + "/folders/advanced-search",
    getDetails: (folderId: number) => `/api/document/folders/details/${folderId}`,
    downloadZip: (folderId: number) => `${endpointPrefix}/folders/download?folderId=${folderId}`,
  },

  Document: {
    upload: endpointPrefix + "/docs/upload",
    getById: (docId: number) => `${endpointPrefix}/docs/${docId}`,
    getByIdAbDriver: (docId: number, ownerId: number) => `${endpointPrefix}/docs/details?documentId=${docId}&ownerUuid=${ownerId}`,
    getUserDocumentsAbDriver: (ownerId: number) => `${endpointPrefix}/docs/user/${ownerId}`,
    getUserDocuments: (ownerUuid : string) => `${endpointPrefix}/docs/all?ownerUuid=${ownerUuid}`,
    getRootDocuments: (ownerUuid : string) => `${endpointPrefix}/docs/root/${ownerUuid}`,
    delete: (ownerId: number, docId: number) => `${endpointPrefix}/docs/delete?ownerUuid=${ownerId}&documentId=${docId}`,
    renameDocument: (ownerId: string, docId: number, newName: string) => `${endpointPrefix}/docs/rename?ownerUuid=${ownerId}&documentId=${docId}&newName=${encodeURIComponent(newName)}`,
    bulkDelete: endpointPrefix + "/docs/bulk/delete",
    move: endpointPrefix + "/docs/move",
    bulkMove: endpointPrefix + "/docs/bulk/move",
    share: endpointPrefix + "/docs/share",
    bulkShare: endpointPrefix + "/docs/bulk/share",
    downloadUrl: (docId: number, ownerUuid : string) => `${endpointPrefix}/docs/download-url/${docId}?ownerUuid=${ownerUuid}`,
    downloadStream: (docId: number, ownerUuid : string) => `${endpointPrefix}/docs/download/${docId}?ownerUuid=${ownerUuid}`,
    favorite: (docId: number) => `${endpointPrefix}/docs/favorite/${docId}`,
    unfavorite: (docId: number) => `${endpointPrefix}/docs/unfavorite/${docId}`,
    getFavorites: (ownerUuid : string) => `${endpointPrefix}/docs/favorites/${ownerUuid}`,
    search: endpointPrefix + "/docs/search",
    advancedSearch: endpointPrefix + "/docs/advanced-search",
    statistics: (ownerUuid : string) => `${endpointPrefix}/docs/statistics/${ownerUuid}`
  },

  Storage: {
    getQuotaInfo: (ownerUuid : string) => `${endpointPrefix}/storage/quota/${ownerUuid}`,
    isQuotaExceeded: (ownerUuid : string) => `${endpointPrefix}/storage/quota-exceeded/${ownerUuid}`,
    getUsed: (ownerUuid : string) => `${endpointPrefix}/storage/used/${ownerUuid}`,
    getAvailable: (ownerUuid : string) => `${endpointPrefix}/storage/available/${ownerUuid}`
  }
};
