const endpointPrefix = "/api/absence/driver";

export const driverAbsenceEndpoints = {
  General: {
    getAll: endpointPrefix + "/all",
    getProcessed: endpointPrefix + "/processed",
    getUnprocessed: endpointPrefix + "/unprocessed",
    getById: (id: number) => endpointPrefix +"/find-driver-absence/" + id,
  },

  Create: {
    create: endpointPrefix + "/create",
  },

  Retrieve: {
    getById: (id: number) => `${endpointPrefix}/find-driver-absence/${id}`,
  },

  Update: {
    update: (id: string) => `${endpointPrefix}/update-driver-absences/${id}`,
  },

  Delete: {
    delete: (id: number) => `${endpointPrefix}/delete-driver-absences/${id}`,
  },

  Status: {
    changeStatus: (id: number,status:string) => `${endpointPrefix}/status/${id}/${status}`,
  },
};