import { ScrollBox } from "@/shared/theme/css"
import { Box, TableCell, Typography } from "@mui/material"
import { styled } from "@mui/system"

export const CalendarHeader = styled(Box)(({ theme }) => ({
  backgroundColor: "white",
  display: "flex",
  padding: theme.spacing(2),
  borderBottom: `1px solid ${theme.palette.divider}`,
  position: "relative",
}))

export const CalendarCell = styled(TableCell, {
  shouldForwardProp: (prop) => prop !== "isCurrentMonth",
})<{ isCurrentMonth: boolean }>(({ theme, isCurrentMonth }) => ({
  border: `1px solid ${theme.palette.divider}`,
  padding: 0,
  height: "calc((100vh - 270px) / 6)",
  verticalAlign: "top",
  backgroundColor: "white",
  position: "relative",
  ...(!isCurrentMonth && {
    color: theme.palette.text.disabled,
  }),
}))

export const DateNumber = styled(Typography, {
  shouldForwardProp: (prop) => prop !== "isToday" && prop !== "itemColor",
})<{ isToday?: boolean; itemColor?: string }>(({ theme, isToday, itemColor }) => ({
  fontSize: "13px",
  position: "absolute",
  top: theme.spacing(0.5),
  left: theme.spacing(0.5),
  zIndex: 1,
  color: itemColor,
  ...(isToday && {
    display: "flex",
    justifyContent: "center",
    width: "22px",
    height: "22px",
    borderRadius: "50%",
    backgroundColor: theme.palette.primary.main,
    color: theme.palette.primary.contrastText,
  }),
}))

export const VacancePeriodItem = styled(Box)(({ theme }) => ({
  display: "flex",
  alignItems: "center",
  gap: theme.spacing(0.5),
  fontSize: "12px",
  padding: theme.spacing(0.25, 0.5),
  whiteSpace: "nowrap",
  overflow: "hidden",
  textOverflow: "ellipsis",
  minHeight: "24px",
  justifyContent: "flex-start",
  position: "relative",
}))

export const PeriodContainer = styled(Box)(({ theme }) => ({
  display: "flex",
  flexDirection: "column",
  height: "100%",
}))

// Annual Calendar
export const StyledYearContainer = styled(ScrollBox)(({ theme }) => ({
  backgroundColor: theme.palette.background.paper,
  borderRadius: theme.shape.borderRadius,
  paddingInline: theme.spacing(2),
  paddingBlockEnd: theme.spacing(2),
}))

export const MonthBox = styled(Box)(({ theme }) => ({
  backgroundColor: theme.palette.background.paper,
  border: `1px solid ${theme.palette.divider}`,
  borderRadius: theme.shape.borderRadius,
  padding: theme.spacing(1),
  height: "100%",
  minHeight: 180,
}))

export const MonthTitle = styled(Typography)(({ theme }) => ({
  fontWeight: 500,
  marginBottom: theme.spacing(1),
  textAlign: "center",
  textTransform: "capitalize",
}))

export const DayCell = styled(Box, {
  shouldForwardProp: (prop) =>
    prop !== "isToday" && prop !== "isCurrentMonth" && prop !== "hasPeriods" && prop !== "size",
})<{
  isToday?: boolean
  isCurrentMonth?: boolean
  hasPeriods?: boolean
  size?: number
}>(({ theme, isToday, isCurrentMonth, hasPeriods, size = 22 }) => ({
  width: size * 0.7,
  height: size* 0.7,
  fontSize: Math.max(10, size * 0.3),
  display: "flex",
  alignItems: "center",
  justifyContent: "center",
  borderRadius: "50%",
  cursor: "pointer",
  backgroundColor: isToday ? theme.palette.primary.main : hasPeriods ? theme.palette.primary.light : "transparent",
  color: isToday
    ? theme.palette.primary.contrastText
    : !isCurrentMonth
      ? theme.palette.text.disabled
      : theme.palette.text.primary,
  "&:hover": {
    backgroundColor: isToday ? theme.palette.primary.dark : theme.palette.primary.lighter,
  },
}))


export const WeekdayHeader = styled(Box)(({ theme }) => ({
  fontSize: 11,
  color: theme.palette.text.secondary,
  fontWeight: 500,
}))