import { Box, Card, Typography, alpha, Grid } from '@mui/material';
import { IconDefinition } from '@fortawesome/fontawesome-svg-core';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';

interface StatItem {
  title: string;
  total: number;
  icon: IconDefinition;
  color: string;
}

interface StatsCardsProps {
  stats: StatItem[];
}

export default function StatsCards({ stats }: StatsCardsProps) {
  return (
    <Grid container spacing={2} sx={{ mb: 2 }}>
      {stats.map((stat) => (
        <Grid item xs={12} sm={6} md={3} key={stat.title}>
          <Card
            sx={{
              p: 1.5,
              height: '100%',
              display: 'flex',
              alignItems: 'center',
              gap: 1.5,
              borderRadius: 2,
              border: (theme) => `1px solid ${theme.palette.divider}`,
              boxShadow: 'none',
              bgcolor: 'background.paper',
              '&:hover': {
                bgcolor: (theme) => alpha(theme.palette.primary.main, 0.02),
                transition: 'background-color 0.3s',
              },
            }}
          >
            <Box
              sx={{
                width: 32,
                height: 32,
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'center',
                borderRadius: '50%',
                bgcolor: (theme) => alpha(stat.color, 0.12),
                flexShrink: 0,
              }}
            >
              <FontAwesomeIcon 
                icon={stat.icon} 
                style={{ 
                  fontSize: '1rem',
                  color: stat.color,
                }} 
              />
            </Box>

            <Box>
              <Typography 
                variant="subtitle1"
                sx={{ 
                  color: stat.color,
                  lineHeight: 1,
                  mb: 0.25,
                  fontWeight: 600,
                }}
              >
                {stat.total}
              </Typography>

              <Typography 
                variant="subtitle2"
                sx={{ 
                  color: 'text.secondary',
                  display: 'block',
                }}
              >
                {stat.title}
              </Typography>
            </Box>
          </Card>
        </Grid>
      ))}
    </Grid>
  );
}