import React from 'react';
import { useSortable } from '@dnd-kit/sortable';
import { CSS } from '@dnd-kit/utilities';
import { Box, Typography, Checkbox, FormControlLabel, alpha } from '@mui/material';

interface SortableItemProps {
  id: string;
  label: string;
  checked: boolean;
  onCheckChange: () => void;
}

export function SortableItem({ id, label, checked, onCheckChange }: SortableItemProps) {
  const {
    attributes,
    listeners,
    setNodeRef,
    transform,
    transition,
    isDragging,
  } = useSortable({ id });

  const style = {
    transform: CSS.Transform.toString(transform),
    transition,
  };

  return (
    <Box
      ref={setNodeRef}
      style={style}
      sx={{
        p: 0.5,
        pl: 1,
        display: 'flex',
        alignItems: 'center',
        gap: 1,
        opacity: isDragging ? 0.5 : 1,
        cursor: 'grab',
        '&:active': { cursor: 'grabbing' },
        bgcolor: checked ? (theme) => theme.palette.primary.main : 'background.paper',
        color: checked ? 'white' : 'text.primary',
        borderRadius: 2,
        '&:hover': {
          bgcolor: (theme) => alpha(theme.palette.primary.main, 0.1),
          color: 'primary.main',
        },
      }}
      {...attributes}
      {...listeners}
    >
      <Typography
        variant="body2"
        sx={{
          flexGrow: 1,
          whiteSpace: 'nowrap',
        }}
      >
        {label}
      </Typography>
      <FormControlLabel
        sx={{ marginRight: 0 }}
        control={
          <Checkbox
            checked={checked}
            onChange={onCheckChange}
            sx={{
              mr: 0,
              '&.Mui-checked': {
                color: 'white',
              },
              '& .MuiSvgIcon-root': {
                fontSize: 16,
              },
            }}
          />
        }
        label=""
      />
    </Box>
  );
}

