import FontAwesome from '@/shared/components/fontawesome';
import SvgColor from '@/shared/components/svg-color';
import { pxToRem } from '@/shared/theme/typography';
import { Box, Popover, Typography } from '@mui/material';
import { IconDefinition } from '@fortawesome/fontawesome-svg-core';
import { getBgColor, StatusColor } from '@/shared/sections/chauffeur/planingChauffeur/utils/schedule-utils';

interface PopoverItem {
  icon: string | IconDefinition;
  value: string | number;
}

interface TimeSlotPopoverProps {
  anchorEl: HTMLElement | null;
  onClose: () => void;
  color: StatusColor;
  data: PopoverItem[];
  arrow?: boolean;
}

export function DetailsPopover({ 
  anchorEl, 
  onClose, 
  data, 
  color,
  arrow = true
}: TimeSlotPopoverProps) {
  const bgColor = getBgColor(color);
  
  return (
    <Popover
      open={Boolean(anchorEl)}
      anchorEl={anchorEl}
      onClose={onClose}
      disableRestoreFocus
      anchorOrigin={{
        vertical: 'center',
        horizontal: 'center',
      }}
      transformOrigin={{
        vertical: 'top',
        horizontal: 'center',
      }}
      sx={{
        pointerEvents: 'none',
        '& .MuiPopover-paper': {
          p: 1,
          mt: 3,
          borderRadius: 4,
          border: `2px solid ${color}`,
          bgcolor: bgColor,
          overflow: 'visible',
          boxShadow: 'none',
          ...(arrow && {
            '&::before': {
              content: '""',
              position: 'absolute',
              top: -10,
              left: '45%',
              width: '10%',
              aspectRatio: '1 / 1',
              backgroundColor: bgColor,
              transform: 'rotate(45deg)',
              borderRadius: 1,
              border: `2px solid ${color}`,
              borderBottom: 'none',
              borderRight: 'none',
              zIndex: 1,
            }
          })
        },
      }}
    >
      <Box sx={{ display: 'flex', flexDirection: 'column', gap: 0 }}>
        {data.map((item, index) => (
          <Box key={index} sx={{ display: 'flex', alignItems: 'center', gap: 2 }}>
            {typeof item.icon === 'string' ? (
              <SvgColor
                src={item.icon}
                sx={{
                  color: { color },
                  width: 13,
                }}
              />
            ) : (
              <FontAwesome icon={item.icon} color={color} width={13} />
            )}
            <Typography sx={{ fontSize: pxToRem(12), color: { color } }}>
              {item.value}
            </Typography>
          </Box>
        ))}
      </Box>
    </Popover>
  );
}