import type React from "react"
import Drawer from "@mui/material/Drawer"
import Box from "@mui/material/Box"
import NavToggleButton from "@/layouts/common/nav-toggle-button"

interface DrawerProps {
  open: boolean
  onClose: () => void
  drawerWidth: number
  children: React.ReactNode
}

export default function CustomDrawer({ drawerWidth, open, onClose, children }: DrawerProps) {
  return (
    <Drawer
      variant="persistent"
      anchor="right"
      open={open}
      onClose={onClose}
      sx={{
        "& .MuiDrawer-paper": {
          width: drawerWidth,
          boxSizing: "border-box",
        },
      }}
    >
      <Box sx={{ position: "relative", height: "100%", px: 2, pb: 3 }}>
        <NavToggleButton
          onClose={onClose}
          sx={{
            right: drawerWidth - 15,
          }}
        />
        {children}
      </Box>
    </Drawer>
  )
}

