import { forwardRef } from 'react';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Box, BoxProps } from '@mui/material';
import { FontAwesomeProps } from './types';
// ----------------------------------------------------------------------

interface Props extends BoxProps {
  icon: FontAwesomeProps;
}

export const FontAwesome = forwardRef<SVGElement, Props>(({ icon, width = {  xs: 20, lg: 22}, sx, ...other }, ref) => {
  return (
    <Box
      ref={ref}
      component={FontAwesomeIcon}
      icon={icon}
      sx={{ width, height: width, ...sx }}
      {...other}
    />
  );
});

FontAwesome.displayName = 'FontAwesome';

export default FontAwesome;
