"use client"

import { Box, Button } from "@mui/material"
import { mainColor, outlinedColor, outlinedGreyColor } from "../table/styles"
import ConditionalComponent from "../table/ConditionalComponent"

interface ActionButtonsProps {
  onCancel: () => void
  onSave?: () => void
  onValidate?: () => void
  onEdit?: () => void
  mode?: string
  readOnly?: boolean
}

export default function FormActions({
  onCancel,
  onSave,
  onValidate,
  onEdit,
  mode,
  readOnly = false,
}: ActionButtonsProps) {
  <ConditionalComponent isValid={readOnly}>
      <Box display="flex" justifyContent="flex-end" gap={2}>
        <Button
          variant="outlined"
          onClick={onCancel}
          sx={{
            textTransform: "none",
            ...outlinedGreyColor,
          }}
        >
          Fermer
        </Button>
        <ConditionalComponent isValid={onEdit != null}>
        <Button
            variant="contained"
            onClick={onEdit}
            sx={{
              boxShadow: "none",
              textTransform: "none",
              ...mainColor,
            }}
          >
            Modifier
          </Button>
        </ConditionalComponent>
      </Box>
</ConditionalComponent>

  return (
    <Box display="flex" justifyContent="flex-end" gap={2}>
      <Button
        variant="outlined"
        onClick={onCancel}
        sx={{
          textTransform: "none",
          ...(onValidate ? outlinedGreyColor : outlinedColor),
        }}
      >
        Annuler
      </Button>
      <ConditionalComponent isValid={!!onSave}>
      <Button
        variant={onValidate ? "outlined" : "contained"}
        onClick={onSave}
        sx={{
          boxShadow: "none",
          textTransform: "none",
          ...(onValidate ? outlinedColor : mainColor),
        }}
      >
        {mode === "edit" ? "Enregistrer" : "Ajouter"}
      </Button>
      </ConditionalComponent>
      
      {onValidate ? (
        <Button
          variant="outlined"
          onClick={onValidate}
          sx={{
            boxShadow: "none",
            textTransform: "none",
            ...mainColor,
          }}
        >
          Enregistrer et Valider
        </Button>
      ) : (
        <></>
      )}
    </Box>
  )
}

