"use client"

import type { ReactNode } from "react"
import { Box, Grid, Typography } from "@mui/material"

interface TabContainerProps {
    id: number
    title: string
    greyBg?: boolean
    children: ReactNode
  }

  export default function TabContainer({ id, title, greyBg, children }: TabContainerProps) {
  return (
    <Grid item xs={12} sm={6}>
      <Box
        sx={{
          border: (theme) => `2px solid ${theme.palette.primary.main}`,
          borderRadius: "12px",
          position: "relative",
          p: "2%",
          overflow: "inherit",
          ...(greyBg ? { backgroundColor: 'grey.200' } : {}),
        }}
      >
        <Typography
          component="div"
          variant="h5"
          sx={{
            position: "absolute",
            top: "-18px",
            left: "16px",
            backgroundColor: "white",
            height: "19px",
            fontWeight: (theme) => theme.typography.fontWeightBold,
            zIndex: 2,
            px: 1,
            color: "primary.main",
          }}
        >
          {title} {id + 1}
        </Typography>
        {children}
      </Box>
    </Grid>
  )
}

