import { Checkbox, CircularProgress, TableCell, TableRow, Typography } from "@mui/material";
import { alpha, styled } from "@mui/system";

  export const HeaderCell = styled(TableCell)(({ theme }) => ({
    textAlign: 'center',
    color: theme.palette.text.disabled,
    padding: '8px',
    border:"none"
  }));
  export const HeaderCellWidthColor = styled(HeaderCell)<{ applySecondaryColor?: boolean }>(({ theme, applySecondaryColor = false }) => ({
    backgroundColor: alpha(theme.palette.primary.main, 0.1),
    ...(applySecondaryColor && {
      color: theme.palette.text.secondary,
    }),
  }))
  export  const HeaderRow = styled(TableCell)<{ highlighted?: boolean   }>(({ theme, highlighted = false }) => ({
    textAlign: 'left',
    color: highlighted ? theme.palette.text.secondary : theme.palette.text.disabled,
    whiteSpace:'nowrap',
    fontWeight:500,
  }));
  export  const StyledTableRow = styled(TableRow)(({ theme }) => ({
    '& > *:first-of-type': {
      borderBottomLeftRadius: '10px',
      borderTopLeftRadius: '10px',
    },
    '& > *:last-child': {
      borderTopRightRadius: '10px',
    },
  }));
  export  const StyledSubTableRow = styled(TableRow)(({ theme }) => ({
    '& > *:last-child': {
      borderBottomRightRadius: '10px',
    },
  }));
  export  const StyledFirstRow = styled(TableRow)(({ theme }) => ({
    backgroundColor: alpha(theme.palette.primary.main, 0.1),
   '& > *': {
    borderTop: '3px solid white',
  },
    '& > *:first-of-type': {
      borderTopLeftRadius: '10px',
    },
    '& > *:last-child': {
      borderTopRightRadius: '10px',
    },
  }));

  export  const StyledEstablishmentRow = styled(TableRow)(({ theme }) => ({
    backgroundColor: 'white',
    '& > *': {
      borderTop: `3px solid ${alpha(theme.palette.primary.main, 0.1)}`,
    },
     '& > *:first-of-type': {
       borderTopLeftRadius: '10px',
       borderBottomLeftRadius: '10px',
     },
     '& > *:last-child': {
       borderTopRightRadius: '10px',
       borderBottomRightRadius: '10px',
     },
   }));
  export  const StyledSecondRow = styled(TableRow)(({ theme }) => ({
    backgroundColor: alpha(theme.palette.primary.main, 0.1),
    '& > *:first-of-type': {
      borderBottomLeftRadius: '10px',
    },
    '& > *:last-child': {
      borderBottomRightRadius: '10px',
    },
  }));
  export const SensARCheckbox = styled(Checkbox)(({ theme }) => ({
    width: 20,
    height: 20,
    padding: 0,
    borderRadius: '50%',
    '& .MuiSvgIcon-root': {
      display: 'none',
    },
    '&.Mui-checked': {
      backgroundColor: theme.palette.primary.main,
    },
    '&:not(.Mui-checked)': {
      backgroundColor: alpha(theme.palette.primary.main, 0.1),
    },
  }));

  export const StyledCircularProgress = styled(CircularProgress)(({ theme }) => ({
    marginRight: '5px',
  }));

  export const DayCheckbox = styled(Checkbox)(({ theme }) => ({
    width: 24,
    height: 24,
    padding: 0,
    borderRadius: "50%",
    "& .MuiSvgIcon-root": {
      display: "none",
    },
    "&.Mui-checked": {
      backgroundColor: theme.palette.primary.main,
    },
    "&:not(.Mui-checked)": {
      backgroundColor: "transparent",
      border: `1px solid ${theme.palette.primary.main}`,
    },
    "&.Mui-disabled:not(.Mui-checked)": {
      border: `1px solid ${theme.palette.action.disabled}`,
    },
    "&.Mui-disabled.Mui-checked": {
      backgroundColor: theme.palette.action.disabled,
    },
  }))
  
  export const DayLabel = styled(Typography)(({ theme }) => ({
    position: "absolute",
    top: "50%",
    left: "50%",
    transform: "translate(-50%, -50%)",
    fontSize: "0.6rem",
    pointerEvents: "none",
  }))