import type React from "react"
import { Box } from "@mui/material"
import FontAwesome from "@/shared/components/fontawesome"
import { faClock } from "@fortawesome/free-solid-svg-icons"
import { containerStyles, InfoItem } from "./utils/journey-summary-utils"

interface JourneySummaryDriverProps {
  departureTime?: string
  arrivalTime?: string
}

export const JourneySummaryDriver: React.FC<JourneySummaryDriverProps> = ({
  departureTime = "",
  arrivalTime = "",
}) => {
    return (
      <Box sx={{ ...containerStyles(false), borderRadius: 0 }}>
        {[
          { label: "Heure de départ :", value: departureTime },
          { label: "Heure d'arrivée :", value: arrivalTime },
        ].map((item, index) => (
          <InfoItem
            key={index}
            icon={<FontAwesome icon={faClock} color="primary.main" width={16} />}
            label={item.label}
            value={item.value || "-"}
          />
        ))}
      </Box>
    )
  }

