'use client';

import { forwardRef } from 'react';
import { Box, BoxProps } from '@mui/material';

interface LabelProps extends BoxProps {
  variant?: 'filled' | 'outlined' | 'soft';
  color?: string;
  startIcon?: React.ReactNode;
  endIcon?: React.ReactNode;
}

const Label = forwardRef<HTMLDivElement, LabelProps>(
  ({ variant = 'soft', color = 'default', startIcon, endIcon, children, sx, ...other }, ref) => {
    const renderContent = () => (
      <Box
        ref={ref}
        component="span"
        sx={{
          ...(variant === 'filled' && {
            color: '#fff',
            backgroundColor: color,
          }),
          ...(variant === 'outlined' && {
            backgroundColor: 'transparent',
            border: `1px solid ${color}`,
            color,
          }),
          ...(variant === 'soft' && {
            backgroundColor: `${color}1A`,
            color,
          }),
          display: 'inline-flex',
          alignItems: 'center',
          justifyContent: 'center',
          minWidth: 22,
          height: 22,
          borderRadius: 6,
          whiteSpace: 'nowrap',
          padding: '0 8px',
          fontSize: '0.75rem',
          fontWeight: 600,
          textTransform: 'capitalize',
          cursor: 'default',
          ...sx,
        }}
        {...other}
      >
        {startIcon && (
          <Box
            component="span"
            sx={{
              mr: 0.75,
              display: 'inherit',
              '& svg': { width: 16, height: 16 },
            }}
          >
            {startIcon}
          </Box>
        )}

        {children}

        {endIcon && (
          <Box
            component="span"
            sx={{
              ml: 0.75,
              display: 'inherit',
              '& svg': { width: 16, height: 16 },
            }}
          >
            {endIcon}
          </Box>
        )}
      </Box>
    );

    return renderContent();
  }
);

Label.displayName = 'Label';

export default Label; 