import FontAwesome from "@/shared/components/fontawesome"
import { faChevronDown, faChevronUp } from "@fortawesome/free-solid-svg-icons"
import {
  Accordion as MuiAccordion,
  type AccordionProps,
  AccordionSummary as MuiAccordionSummary,
  type AccordionSummaryProps,
  Box,
} from "@mui/material"
import { styled } from "@mui/system"
import { IconButtonProps } from "./types"

export const CustomAccordion = styled((props: AccordionProps) => (
  <MuiAccordion disableGutters elevation={0} square {...props} />
))(({ theme, expanded }) => ({
  border: "none",
  borderBottom: `2px solid ${expanded ? "#746CD4" : "#E0DDF8"}`,

  "&:not(:last-child)": {
    marginBottom: "12px",
  },
  "&:first-child": {
    borderTop: `2px solid ${expanded ? "#746CD4" : "#E0DDF8"}`,
  },
  "&:before": {
    display: "none",
  },
}))

const IconButton = ({ isExpanded, icon, onClick, position = "top" }: IconButtonProps) => {
  const positionStyles = position === "top" ? { top: 20 } : { bottom: -11 }

  return (
    <Box
      onClick={(e) => {
        e.stopPropagation()
        onClick?.(e)
      }}
      sx={{
        backgroundColor: isExpanded ? "primary.light" : "white",
        borderRadius: "50%",
        width: 22,
        height: 22,
        display: "flex",
        alignItems: "center",
        color: isExpanded ? "primary.main" : "primary.light",
        border: `2px solid ${isExpanded ? "#746CD4" : "#E0DDF8"}`,
        justifyContent: "center",
        position: "absolute",
        left: "50%",
        transform: "translateX(-50%)",
        zIndex: 10,
        cursor: "pointer",
        boxShadow: "0 1px 3px rgba(0,0,0,0.1)",
        ...positionStyles,
      }}
    >
      <FontAwesome icon={icon} width={12} />
    </Box>
  )
}

export const CustomAccordionSummary = styled((props: AccordionSummaryProps & { isExpanded?: boolean; onIconClick?: (e: React.MouseEvent) => void }) => {
  const { isExpanded, onIconClick, ...other } = props;
  return (
    <MuiAccordionSummary
      expandIcon={
        !isExpanded ? <IconButton onClick={onIconClick} isExpanded={false} icon={faChevronDown} position="top" /> : <></>
      }
      {...other}
    />
  )
})(({ theme }) => ({
  paddingBottom: "12px",
  "& .MuiAccordionSummary-content": {
    margin: 0,
    justifyContent: "center",
  },
  "& .MuiAccordionSummary-expandIconWrapper": {
    position: "absolute",
  },
}))

export const AccordionToggleButton = ({ isExpanded, onClick }: { isExpanded: boolean; onClick: () => void }) => {
  if (!isExpanded) return <></>
  return <IconButton isExpanded={true} icon={faChevronUp} onClick={onClick} position="bottom" />
}

