import { Button, Select, Switch, TextField } from '@mui/material';
import { alpha, styled } from "@mui/system";
import { Theme } from "@mui/material/styles";

export const StyledTextField = styled(TextField)(({ theme }) => ({
  '& .MuiInputBase-root': {
    fontSize: '0.9rem',
    transition: 'box-shadow 0.3s ease',
    '&:focus-within': {
      boxShadow: `0 0 0 4px ${alpha(theme.palette.primary.main, 0.1)}`,
    },
  },
  '& .MuiInputBase-input': {
    borderRadius: '1px',
    padding: 8,
    height: '1.1rem',
  },
}));

  export const StyledSelect = styled(Select)({

    '& .MuiSelect-select': {
      borderRadius: '1px',
      padding: 8,
      height: '1rem',
      fontSize: '0.875rem',
    },
  });
  export const AntSwitch = styled(Switch)(({ theme }: { theme: Theme }) => ({
    width: 23,
    height: 13,
    padding: 0,
    display: 'flex',
    '&:active': {
      '& .MuiSwitch-thumb': {
        width: 12,
      },
      '& .MuiSwitch-switchBase.Mui-checked': {
        transform: 'translateX(8px)',
      },
    },
    '& .MuiSwitch-switchBase': {
      padding: 1,
      '&.Mui-checked': {
        transform: 'translateX(10px)',
        color: '#fff',
        '& + .MuiSwitch-track': {
          opacity: 1,
          backgroundColor: theme.palette.primary.main,
        },
      },
    },
    '& .MuiSwitch-thumb': {
      boxShadow: '0 1px 3px 0 rgb(0 35 11 / 20%)',
      width: 11,
      height: 11,
      borderRadius: 5,
      transition: theme.transitions.create(['width'], {
        duration: 200,
      }),
    },
    '& .MuiSwitch-track': {
      borderRadius: 14 / 2,
      opacity: 1,
      backgroundColor: 'rgba(0,0,0,.25)',
      boxSizing: 'border-box',
    },
  }));
  export const buttonStyle = {
    width: 30,
    height: 30,
    minWidth: 30,
    borderRadius: '50%',
    padding: 0,
    mx: 0.25,
    bgcolor: 'background.paper',
    color: 'text.secondary',
    '&:hover': {
      bgcolor: 'action.hover',
    },
  };
  export const mainButtonStyle ={
    padding: 0,
    color: 'primary.main',
    '&:hover': {
      color: 'primary.dark',
    },
  }
  export const pointStyle = {
    width: 30,
    height: 30,
    borderRadius: '8px',
    mx: 0.25,
    bgcolor: 'background.paper',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
  };

  export const mainColor = {
    backgroundColor:'primary.main',
    color: 'primary.contrastText',
    '&:hover': {
      backgroundColor: 'primary.dark',
    },
  };
  
  export const activeButtonStyle = {
    ...buttonStyle,
    ...mainColor,
  };
  
  export const lightColor = {
    color: 'primary.main',
    bgcolor: 'primary.lighter',
    '&:hover': {
      backgroundColor: 'primary.light',
    },
  };
  export const greyColor = {
    color: (theme: any) => theme.palette.grey[600],
    bgcolor: "#EFF1F2",
  };
  export const redColor = {
    backgroundColor: '#FFE1E1',
    color: '#FF3434',
  };
  export const greenColor = {
    backgroundColor: '#E9FBF0',
    color: '#36B37E',
  };
  export const secoundaryColor = {
    backgroundColor:'white',
    color:alpha("#617581",0.8),
    '&:hover': {
      backgroundColor: 'action.hover',
    },
  };
  
  
  export const outlinedColor = {
    borderColor: 'primary.main',
    color: 'primary.main',
    '&:hover': {
      borderColor: '#5B3EEF',
      backgroundColor: 'rgba(107, 78, 255, 0.04)',
    },
  };

  export const outlinedGreyColor = {
    borderColor: 'text.disabled',
    color: 'text.disabled',
    '&:hover': {
      borderColor: 'text.disabled',
      backgroundColor:  'rgba(39, 39, 39, 0.04)',
    },
  };
  
  export const AddButton = styled(Button)(({ theme }) => ({
    ...mainColor,
    boxShadow: 'none',
    textTransform: 'none',
    padding: '4px 7px',
    borderRadius: '6px',
    
  }))
  
  export const ColumnButton = styled(Button)(({ theme }) => ({
    boxShadow: 'none',
    textTransform: 'none',
    padding: '4px 7px',
    borderRadius: '6px',
  }))
  
 
  export const visuallyHidden = {
    border: 0,
    margin: -1,
    padding: 0,
    width: "1px",
    height: "1px",
    overflow: "hidden",
    position: "absolute",
    whiteSpace: "nowrap",
    clip: "rect(0 0 0 0)",
  };
  