// ----------------------------------------------------------------------

  
  function descendingComparator<T>(a: T, b: T, orderBy: keyof T) {
    const aValue = a[orderBy];
    const bValue = b[orderBy];
  
    // Handle cases where values might be undefined
    if (aValue === undefined) return 1;
    if (bValue === undefined) return -1;
    
    // Handle null values if needed
    if (aValue === null) return 1;
    if (bValue === null) return -1;
    
    // Ensure that the values are comparable
    if (typeof aValue === 'string' && typeof bValue === 'string') {
      return aValue.localeCompare(bValue);
    }
    if (typeof aValue === 'number' && typeof bValue === 'number') {
      return aValue - bValue;
    }
    
    // Fallback comparison if types are inconsistent
    return 0;
  }
  
  export function getComparator<Key extends keyof any>(
    order: 'asc' | 'desc',
    orderBy: Key
  ): (a: { [key in Key]: number | string | undefined }, b: { [key in Key]: number | string | undefined }) => number {
    return order === 'desc'
      ? (a, b) => descendingComparator(a, b, orderBy)
      : (a, b) => -descendingComparator(a, b, orderBy);
  }
  