import React from 'react';
import { Box, Tabs, IconButton, Tab } from '@mui/material';
import CloseIcon from '@mui/icons-material/Close';
import { TabItem } from '@/hooks/use-tabs-manager';
import { StyledTab, tabsStyles } from '@/shared/theme/css';

interface TabsProps {
  type: string;
  tabs: TabItem<any>[];
  activeTab: string;
  handleTabChange: (event: React.SyntheticEvent, newValue: string) => void;
  handleTabClose: (event: React.MouseEvent, tabId: string) => void;
}

export default function TabsCustom({
  type,
  tabs,
  activeTab,
  handleTabChange,
  handleTabClose,
}: TabsProps) {
  return (
    <Box sx={{ display: 'flex' }}>
      <Tabs 
        value={activeTab} 
        onChange={handleTabChange}
        sx={tabsStyles}
      >
        {tabs.map((tab) => (
          <StyledTab
            key={tab.id}
            value={tab.id}
            label={
              <Box sx={{ display: 'flex', alignItems: 'center', gap: 1 }}>
                {tab.title}
                {(tab.closeable ?? true) && (   
    <IconButton
      size="small"
      onClick={(e) => handleTabClose(e, tab.id)}
      sx={{
        color: 'inherit',
        padding: '2px',
        '&:hover': {
          backgroundColor: 'rgba(255, 255, 255, 0.1)',
        },
      }}
    >
      <CloseIcon sx={{ fontSize: '16px' }} />
    </IconButton>
  )}
              </Box>
            }
          />
        ))}
      </Tabs>
    </Box>
  );
}
