import { ColorSchema } from "@/shared/theme/palette"
import { Tooltip, type TooltipProps } from "@mui/material"
import { styled } from "@mui/material/styles"

interface CustomTooltipProps extends TooltipProps {
  colorSchema?: ColorSchema
}

const CustomTooltip = styled(({ className, colorSchema, ...props }: CustomTooltipProps) => (
  <Tooltip {...props} classes={{ popper: className }} />
))(({ theme, colorSchema }) => {
  let color = theme.palette.primary.main

  if (colorSchema) {
    color = theme.palette[colorSchema].main
  }

  return {
    [`& .MuiTooltip-tooltip`]: {
      backgroundColor: color,
      borderRadius: "8px",
    },
    [`& .MuiTooltip-arrow`]: {
      color: color,
    },
  }
})

export default CustomTooltip
