import { _CIRCUIT_STATUS } from "@/shared/_mock/_circuit"
import { _OPTION_ACTIF } from "@/shared/_mock/_Contrat"
import type { FormFieldType } from "@/shared/types/common"
import type { IPreparationDriver } from "@/shared/types/driver"
import { faCar, faHashtag, faMagnifyingGlass, faNoteSticky, faUserTie } from "@fortawesome/free-solid-svg-icons"

export const _CIRCUIT_NAMES = [
  { value: "Ligne Nord", label: "Ligne Nord" },
  { value: "Ligne Sud", label: "Ligne Sud" },
  { value: "Ligne Est", label: "Ligne Est" },
  { value: "Ligne Ouest", label: "Ligne Ouest" },
]

export const preparationDriverFormFields: FormFieldType<IPreparationDriver>[] = [
  {
    name: "nom",
    label: "Nom",
    type: "text",
    placeholder: "Entrez un nom",
    required: true,
    icon:faUserTie
  },
  {
    name: "prenom",
    label: "Prénom",
    type: "text",
    placeholder: "Entrez un prénom",
    required: true,
    icon:faUserTie
  },
  {
    name: "adresse",
    label: "Adresse",
    type: "address",
    placeholder: "Entrez une adresse",
    required: true,
  },
  {
    name: "ville",
    label: "Ville",
    type: "text",
    placeholder: "Entrez un nom",
    required: true,
    icon:faMagnifyingGlass
  },
  {
    name: "codePostal",
    label: "Code Postal",
    type: "text",
    placeholder: "0000 0000 000 0000",
    required: true,
    icon:faHashtag
  },
  {
    name: "disponibilite",
    label: "Disponibilité",
    type: "date",
    placeholder: "JJ/MM/AAAA",
  },
  {
    name: "nomCircuit",
    label: "Circuit",
    type: "select",
    options: _CIRCUIT_NAMES,
  },
    {
      name: 'vehicle',
      label: 'Véhicule attribué',
      type: 'text',
      placeholder: 'Entrez un nom',
      icon: faCar,
    },
  {
    name: "codeChauffeur",
    label: "Code Chauffeur",
    type: "text",
    placeholder: "0000 0000 000 0000",
    icon:faHashtag
  },
  {
    name: "dateDepart",
    label: "Date d'ajout",
    type: "date",
    placeholder: "JJ/MM/AAAA",
  },
  {
    name: "etat",
    label: "État",
    type: "select",
    options: _OPTION_ACTIF,
  },
  {
    name: "observation",
    label: "Observation",
    type: "textarea",
    placeholder: "Ajoutez une note ou une observation",
    icon:faNoteSticky
  },
]
