"use client"

import { TableRow, TableCell, IconButton, Stack, Checkbox } from "@mui/material"
import FontAwesome from "@/shared/components/fontawesome"
import { faCopy, faEye, faPen, faPenToSquare, faTrash } from "@fortawesome/free-solid-svg-icons"
import CustomTooltip from "@/shared/components/tooltips/tooltip-custom"
import type { IPreparationDriver } from "@/shared/types/driver"
import type { TableColumn } from "@/shared/types/common"
import { formatDate } from "@/utils/format-time"
import { DrawerStyledRow, getStatusColor } from "@/shared/sections/contract/styles"
import SvgColor from "@/shared/components/svg-color"
import { ActionsIconButton } from "@/shared/theme/css"
import ConditionalComponent from "@/shared/components/table/ConditionalComponent"

type Props = {
  row: IPreparationDriver
  dense: boolean
  selected: boolean
  onSelectRow: () => void
  handleEdit: (usager: IPreparationDriver) => void;
  handleDetails: (usager: IPreparationDriver) => void;
  handleCopy: (usager: IPreparationDriver) => void;
  columns: TableColumn[]
}

const TOOLTIP_TITLES = {
  edit: 'Modifier Chauffeur',
  delete: 'Supprimer Chauffeur',
};

export default function DriverTableRow({
  row,
  dense,
  selected,
  onSelectRow,
  handleEdit,
  handleCopy,
  handleDetails,
  columns,
}: Props) {
  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case 'adresse':
        return (
          row.adresse.address
        );
      default:
        return value;
    }
  };
  return (
    <DrawerStyledRow style={{ cursor: 'pointer' }}>

      {columns.map((column: TableColumn, index: number) => (
        <TableCell
          onDoubleClick={() => handleDetails(row)}
          key={column.id}
          align={column.align}
          sx={{ whiteSpace: 'nowrap',
            ...(index === 0 && {
              position: 'relative',
            }),
            py: dense ? 0 : 2, px: 0 }}
        >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
              src="/assets/icons/ic_border.svg"
              sx={{ position: 'absolute', top: 0, left: -4, height: '100%', color: getStatusColor(row.nom),
              }}
            />
            </ConditionalComponent>
          {renderCellContent(column.id, row[column.id as keyof IPreparationDriver])}
        </TableCell>
      ))}

      <TableCell sx={{ whiteSpace: 'nowrap', px: 1, alignItems: 'center' }}>
        <CustomTooltip title={TOOLTIP_TITLES.edit} arrow>
          <IconButton onClick={() => handleEdit(row)} size="small" sx={ActionsIconButton}>
            <FontAwesome icon={faPenToSquare} width={14} />
          </IconButton>
        </CustomTooltip>
        <CustomTooltip title={TOOLTIP_TITLES.delete} arrow>
          <IconButton onClick={() => void 0} size="small" sx={ActionsIconButton}>
            <FontAwesome icon={faTrash} width={14} />
          </IconButton>
        </CustomTooltip>
      </TableCell>
    </DrawerStyledRow>
  );
}
