import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import type { TableColumn } from '@/shared/types/common';
import {
  ContratStyledRow,
  DrawerStyledRow,
  getStatusColor,
  TrajetStyledRow,
} from '@/shared/sections/contract/styles';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import { IconButton } from '@mui/material';
import FontAwesome from '@/shared/components/fontawesome';
import { faPenToSquare, faTrash } from '@fortawesome/free-solid-svg-icons';
import { ActionsIconButton } from '@/shared/theme/css';
import { IPreparationCircuit } from '@/shared/types/circuit';
import SvgColor from '@/shared/components/svg-color';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

type Props = {
  handleEdit: (circuit: IPreparationCircuit) => void;
  handleDetails: (circuit: IPreparationCircuit) => void;
  handleCopy: (circuit: IPreparationCircuit) => void;
  selected: boolean;
  row: IPreparationCircuit;
  dense: boolean;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
};

const TOOLTIP_TITLES = {
  edit: 'Modifier circuit',
  delete: 'Supprimer circuit',
};

export default function CircuitTableRow({
  dense,
  row,
  handleEdit,
  handleDetails,
  handleCopy,
  selected,
  onSelectRow,
  columns,
}: Props) {
  const renderCellContent = (columnId: string, value: any) => {
      switch (columnId) {
        case 'adresseEtablissement':
          return (
            row.adresseEtablissement.address
          );
        default:
          return value;
      }
    };
  return (
    <DrawerStyledRow style={{ cursor: 'pointer' }}>
      {columns.map((column: TableColumn, index: number) => (
        <TableCell
          onDoubleClick={() => handleDetails(row)}
          key={column.id}
          align={column.align}
          sx={{ whiteSpace: 'nowrap',
            ...(index === 0 && {
              position: 'relative',
            }),
            py: dense ? 0 : 2, px: 0 }}
        >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
              src="/assets/icons/ic_border.svg"
              sx={{ position: 'absolute', top: 0, left: -4, height: '100%', color: getStatusColor(row.codeCircuit),
              }}
            />
          </ConditionalComponent>  
          {renderCellContent(column.id, row[column.id as keyof IPreparationCircuit])}
        </TableCell>
      ))}

      <TableCell sx={{ whiteSpace: 'nowrap', px: 1, alignItems: 'center' }}>
        <CustomTooltip title={TOOLTIP_TITLES.edit} arrow>
          <IconButton onClick={() => handleEdit(row)} size="small" sx={ActionsIconButton}>
            <FontAwesome icon={faPenToSquare} width={14} />
          </IconButton>
        </CustomTooltip>
        <CustomTooltip title={TOOLTIP_TITLES.delete} arrow>
          <IconButton onClick={() => void 0} size="small" sx={ActionsIconButton}>
            <FontAwesome icon={faTrash} width={14} />
          </IconButton>
        </CustomTooltip>
      </TableCell>
    </DrawerStyledRow>
  );
}
