import { _BINARY_Qst } from "@/shared/_mock/_trajets";
import { FormFieldType } from "@/shared/types/common";
import { IPreparationUsager } from "@/shared/types/usager";
import { faHashtag, faListUl, faMapLocationDot, faNoteSticky, faUserTie } from "@fortawesome/free-solid-svg-icons";
import { _CIRCUIT_NAMES } from "../../chauffeur/utils/form-fields-driver";
import { etablissementsOptions } from "@/shared/_mock/_avenantUsager";

export const preparationUsagerFormFields: FormFieldType<IPreparationUsager >[] = [
  {
    name: 'nom',
    label: 'Nom',
    type: 'text',
    placeholder: 'Entrez un texte',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'prenom',
    label: 'Prénom',
    type: 'text',
    placeholder: 'Entrez un texte',
    required: true,
    icon: faUserTie,
  },
  {
    name: 'adresse',
    label: 'Adresse',
    type: 'address',
  },
  {
    name: 'etat',
    label: 'État',
    type: 'select',
    placeholder: 'Choisissez une valeur',
    required: true,
    options: []
  },
  {
    name: 'dateNaissance',
    label: 'Date de naissance',
    type: 'date',
  },
  {
    name: 'debutTransport',
    label: 'Début de transport',
    type: 'date',
  },
  {
    name: 'categorie',
    label: 'Catégorie',
    type: 'select',
    placeholder: 'Choisissez une valeur',
  },
  {
    name: 'specificite',
    label: 'Spécificité',
    type: 'text',
    placeholder: 'Entrez un texte',
    icon: faListUl,
  },
  {
    name: 'dateAvenant',
    label: 'Date Avenant',
    type: 'date',
  },
  {
    name: 'class',
    label: 'Classe',
    placeholder: 'Entrez un texte',
    type: 'select',
    options: []
  },
  {
    name: "circuit",
    label: "Circuit",
    type: "select",
    options: _CIRCUIT_NAMES,
  },
  {
    name: 'transportSpecificity',
    label: 'Particularité du transport',
    type: 'select',
    placeholder: 'Choisissez un nom',
    options: _BINARY_Qst
  },
  {
    name: 'code',
    label: 'Code',
    type: 'text',
    placeholder: 'XXXX 0000 0000 000',
    icon: faHashtag
  },
  {
    name: 'etablissement',
    label: 'Établissement',
    type: 'select',
    placeholder: 'Choisissez un nom',
    options: etablissementsOptions,
  },
  {
    name: 'observation',
    label: 'Observation',
    type: 'textarea',
    placeholder: 'Ajoutez une note ou une observation',
    icon:faNoteSticky
  }
];