import { Sens } from '@/shared/types/circuit';

// State mapping constants
export const FRONTEND_STATES = {
  PROCESSED: 'Traité',
  IN_PROGRESS: 'En cours',
  CANCELLED: 'Annulé',
  UNPROCESSED: 'Non traité',
} as const;

export const BACKEND_STATES = {
  PROCESSED: 'Processed',
  IN_PROGRESS: 'In_progress',
  CANCELLED: 'Cancelled',
  UNPROCESSED: 'Unprocessed',
} as const;

// State mapping functions
export const mapStateToBackend = (frontendState: string | string[]): string => {
  const state = Array.isArray(frontendState) ? frontendState[0] : frontendState;
  switch (state) {
    case FRONTEND_STATES.PROCESSED:
      return BACKEND_STATES.PROCESSED;
    case FRONTEND_STATES.IN_PROGRESS:
      return BACKEND_STATES.IN_PROGRESS;
    case FRONTEND_STATES.CANCELLED:
      return BACKEND_STATES.CANCELLED;
    case FRONTEND_STATES.UNPROCESSED:
      return BACKEND_STATES.UNPROCESSED;
    default:
      return BACKEND_STATES.UNPROCESSED;
  }
};

export const mapStateToFrontend = (backendState: string): string => {
  switch (backendState) {
    case BACKEND_STATES.PROCESSED:
      return FRONTEND_STATES.PROCESSED;
    case BACKEND_STATES.IN_PROGRESS:
      return FRONTEND_STATES.IN_PROGRESS;
    case BACKEND_STATES.CANCELLED:
      return FRONTEND_STATES.CANCELLED;
    case BACKEND_STATES.UNPROCESSED:
      return FRONTEND_STATES.UNPROCESSED;
    default:
      return FRONTEND_STATES.UNPROCESSED;
  }
};

// Trip mapping functions
export const mapTripToBackend = (frontendTrip: string): string => 
  frontendTrip === 'aller' ? 'Outbound' : 'Return';

export const mapTripToFrontend = (backendTrip: string): string => 
  backendTrip === 'Outbound' ? 'aller' : 'retour';

// Original constants
export const SENS_AR = [
  { value: Sens.Aller, label: "Aller" },
  { value: Sens.Retour, label: "Retour" }
];

export const EXPORT_OPTIONS = [
  {
    label: "Exporter en CSV",
    action: () => {} // This will be injected from the component
  }
];

// State options for different tables
export const UNPROCESSED_STATE_OPTIONS = [
  { value: FRONTEND_STATES.UNPROCESSED, label: FRONTEND_STATES.UNPROCESSED },
  { value: FRONTEND_STATES.IN_PROGRESS, label: FRONTEND_STATES.IN_PROGRESS }
];

export const PROCESSED_STATE_OPTIONS = [
  { value: FRONTEND_STATES.PROCESSED, label: FRONTEND_STATES.PROCESSED },
  { value: FRONTEND_STATES.CANCELLED, label: FRONTEND_STATES.CANCELLED }
];

export const TRAJET_OPTIONS = [
  { value: 'aller', label: 'Aller' },
  { value: 'retour', label: 'Retour' },
  { value: 'A/R', label: 'A/R' }
]; 