import * as Yup from 'yup';
import { IPassenger } from '@/shared/types/absence';

export const absenceValidationSchema = Yup.object().shape({
  usager: Yup.object<IPassenger>()
    .test('is-valid', 'L\'usager est obligatoire', function(value: any) {
      return value?.id && value.id !== 0;
    }),
  dateDebut: Yup.string().required('La date de début est requise'),
  dateFin: Yup.string()
    .required('La date de fin est requise')
    .test('is-after-start', 'La date de fin doit être après la date de début', function(value) {
      const { dateDebut } = this.parent;
      if (!dateDebut || !value) return true;
      return new Date(value) >= new Date(dateDebut);
    }),
  sensAR: Yup.array()
    .of(Yup.string())
    .min(1, 'Au moins un trajet doit être sélectionné')
    .required('Le sens est requis'),
  modeReception: Yup.string().required('Le mode de réception est requis'),
  etat: Yup.mixed()
    .test('required', 'L\'état est requis', function(value) {
      if (!value) return false;
      if (typeof value === 'string') return true;
      if (Array.isArray(value) && value.length > 0) return true;
      return false;
    }),
  previentLe: Yup.string().required('La date de prévention est requise'),
  par: Yup.string().required('Le champ "par" est requis'),
  observation: Yup.string(),
  comment: Yup.string(),
}); 
