import { Chip } from '@mui/material';
import { alpha, styled } from '@mui/material/styles';

export const AbsenceStatusChip = styled(Chip)(({ status, theme }: { status: string; theme: any }) => ({
  '&.MuiChip-root': {
    fontWeight: 500,
    borderRadius: '8px',
    padding: '9px 0',
    height: '100%',
    width: '100%',
    // Non traité and Annulé - Red
    ...((status === 'Non traité' || status === 'Annulé') && {
      backgroundColor: '#FFE1E1',
      color: '#FF3434',
    }),
    // Traité - Green
    ...(status === 'Traité' && {
      backgroundColor: '#E9FBF0',
      color: '#36B37E',
    }),
    // En cours - Yellow/Orange
    ...(status === 'En cours' && {
      backgroundColor: '#FEF8E7',
      color: '#F9B90B',
    }),
    // For trajet options (aller/retour)
    ...(status === 'aller' && {
      backgroundColor: alpha(theme.palette.primary.main, 0.1),
      color: theme.palette.primary.main,
    }),
    ...(status === 'retour' && {
      backgroundColor: '#F4F6F8',
      color: '#637381',
    }),
  },
}));

// Update the helper function for the left border color as well
export const getAbsenceStatusColor = (status: string) => {
  switch (status) {
    case 'Non traité':
    case 'Annulé':
      return '#FF3434'; // Red
    case 'Traité':
      return '#36B37E'; // Green
    case 'En cours':
      return '#F9B90B'; // Yellow/Orange
    default:
      return '#81919A';
  }
}; 