'use client';

import React, { useState } from 'react';
import { Box, Tabs, Tab, useTheme } from '@mui/material';
import { 
  People as PeopleIcon,
  Security as SecurityIcon,
  Groups as TeamsIcon,
} from '@mui/icons-material';
import AgentContent from './agent/view/agent-content';
import RoleContent from './role/view/role-content';
import EquipeListView from './equipes/view/equipe-list-view';
import { HEADER } from '@/layouts/config-layout';

export default function AgentRoleView() {
  const [activeTab, setActiveTab] = useState('agents');
  const theme = useTheme();
  const tabs = [
    { id: 'agents', label: 'Gestion des Agents', icon: <PeopleIcon /> },
    { id: 'teams', label: 'Gestion des Équipes', icon: <TeamsIcon /> },
    { id: 'roles', label: 'Gestion des Rôles', icon: <SecurityIcon /> },

  ];

  const handleChange = (event: React.SyntheticEvent, newValue: string) => {
    setActiveTab(newValue);
  };

  const renderContent = () => {
    switch (activeTab) {
      case 'agents':
        return <AgentContent />;
      case 'roles':
        return <RoleContent />;
      case 'teams':
        return <EquipeListView />;
      default:
        return <AgentContent />;
    }
  };

  return (
      <Box sx={{ display: 'flex', flexDirection: 'column', height: `calc(100vh - ${HEADER.H_DESKTOP + 8}px)` }}>
        <Box >
        <Tabs 
          value={activeTab}
          onChange={handleChange}
          sx={{
            minHeight: '40px',
            '& .MuiTabs-indicator': {
              display: 'none', 
            },
            '& .MuiTab-root': {
              minHeight: '40px',
              textTransform: 'none',
              color: '#666',
              bgcolor: 'background.paper', // Fond blanc pour les onglets
              borderRadius: '12px 12px 0 0',
              mx: 0.25, // Espace entre les onglets
              borderRight: '1px solid #E0E0E0',
              borderTop: '1px solid #E0E0E0',
              borderLeft: '1px solid #E0E0E0',
              borderBottom: 'none',
              px: { xs: 2, md: 3 },
              '&.Mui-selected': {
                color: '#fff',
                bgcolor: theme.palette.primary.main, // Couleur violette pour l'onglet actif
                borderRight: '1px solid #7452d8',
                borderTop: '1px solid #7452d8',
                borderLeft: '1px solid #7452d8',
              },
              '&:not(.Mui-selected)': {
                bgcolor: 'background.paper', // Fond blanc pour les onglets non sélectionnés
                borderBottom: '2px solid #7452d8', // Bordure inférieure violette pour les onglets non sélectionnés
              }
            }
          }}
        >
          {tabs.map((tab) => (
            <Tab
              key={tab.id}
              value={tab.id}
              label={tab.label}
              icon={tab.icon}
              iconPosition="start"
            />
          ))}
        </Tabs>
      </Box>

      <Box sx={{ flexGrow: 1, p: 3, overflow: 'auto' }}>
        {renderContent()}
      </Box>
    </Box>
  );
}