import React from 'react';
import { IAgent } from '@/shared/types/client';
import TableManager from '@/shared/components/table/table-manager';
import { TableColumn } from '@/shared/types/common';
import AgentTableRow from '../view/agent-table-row';

interface AgentTableProps {
  filteredData: IAgent[];
  table: ReturnType<typeof import('@/shared/components/table/use-tablets').default>;
  tableHead: TableColumn[];
  notFound: boolean;
  filters: Record<string, { value: string; condition: string }>;
  onFilterChange: (key: string, value: string, condition: string) => void;
  handleEdit: (item: IAgent) => void;
  handleCopy: (item: IAgent) => void;
  handleView: (item: IAgent) => void;
  onStatusChange: (row: IAgent, newStatus: string, field: keyof IAgent) => void;
  loading?: boolean;
  page?: number;
  onPageChange?: (event: unknown, newPage: number) => void;
  onRowsPerPageChange?: (event: React.ChangeEvent<HTMLInputElement>) => void;
  rowsPerPage?: number;
  count?: number;
  sortBy?: string;
  sortDirection?: 'asc' | 'desc';
}

export default function AgentTable({
  filteredData,
  table,
  tableHead,
  notFound,
  filters,
  onFilterChange,
  handleEdit,
  handleCopy,
  handleView,
  loading,
  onStatusChange,
  page,
  onPageChange,
  onRowsPerPageChange,
  rowsPerPage,
  count,
  sortBy,
  sortDirection,
}: AgentTableProps) {
  const renderRow = (row: IAgent) => (
    <AgentTableRow
      key={row.id}
      row={row}
      handleEditAgent={handleEdit}
      handleCopyAgent={handleCopy}
      handleDetailsAgent={handleView}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead.slice(0, -1)}
      onStatusChange={onStatusChange}
    />
  );

  return (
    <TableManager
      filteredData={filteredData}
      table={table}
      tableHead={tableHead}
      notFound={notFound}
      filters={filters}
      onFilterChange={onFilterChange}
      renderRow={renderRow}
      loading={loading}
      page={page}
      onPageChange={onPageChange}
      onRowsPerPageChange={onRowsPerPageChange}
      rowsPerPage={rowsPerPage}
      count={count}
      sortBy={sortBy}
      sortDirection={sortDirection}
    />
  );
}