import * as Yup from 'yup';

export const equipeSchema = Yup.object().shape({
  name: Yup.string()
    .required('Le nom de l\'équipe est requis')
    .min(2, 'Le nom doit contenir au moins 2 caractères'),
  teamLeaderId: Yup.number()
    .required("Le leader de l'équipe est requis"),
  department: Yup.object().shape({
    id: Yup.number().required('Le département est requis')
  }).nullable(),
  creationDate: Yup.date()
    .required('La date de création est requise'),
  status: Yup.string()
    .required('Le statut est requis'),
  collaborators: Yup.array()
    .of(
      Yup.object().shape({
        id: Yup.number().required(),
      })
    )
    .min(1, 'Au moins un agent doit être assigné à l\'équipe'),
});