"use client"

import { Dialog, DialogTitle, DialogContent, DialogActions, Button, Typography, IconButton } from "@mui/material"
import { Close as CloseIcon, Warning as WarningIcon } from "@mui/icons-material"
import type { IEmailAutomation } from "@/shared/types/email-automation"

interface EmailAutomationArchiveProps {
  open: boolean
  automation: IEmailAutomation | null
  onClose: () => void
  onArchive: (id: string) => void
}

export default function EmailAutomationArchive({ open, automation, onClose, onArchive }: EmailAutomationArchiveProps) {
  if (!automation) {
    return null
  }

  const handleArchive = () => {
    onArchive(automation.id)
    onClose()
  }

  return (
    <Dialog
      open={open}
      onClose={onClose}
      maxWidth="sm"
      fullWidth
      PaperProps={{
        sx: {
          borderRadius: 4,
          overflow: "hidden",
        },
      }}
    >
      <DialogTitle
        sx={{
          display: "flex",
          alignItems: "center",
          gap: 1,
          backgroundColor: "primary.main",
          color: "white",
          fontWeight: "600",
          padding: "16px 24px",
          borderBottom: (theme) => `1px solid ${theme.palette.divider}`,
        }}
      >
        <WarningIcon color="warning" />
        <Typography variant="h6" sx={{ fontSize: "1.25rem", fontWeight: "bold", color: "white" }}>
        Archiver la règle d&#39;envoi automatique
        </Typography>
        <IconButton
          aria-label="close"
          onClick={onClose}
          sx={{
            position: "absolute",
            right: 8,
            top: 8,
            color: "white",
          }}
        >
          <CloseIcon />
        </IconButton>
      </DialogTitle>

      <DialogContent sx={{ backgroundColor: "#fafafa", padding: "24px" }}>
        <Typography variant="body1" gutterBottom>
        Voulez-vous vraiment archiver la règle d&#39;envoi automatique suivante ?
        </Typography>
        <Typography variant="subtitle1" sx={{ mt: 2 }}>
          {automation.nom}
        </Typography>
        <Typography variant="body2" color="text.secondary">
          Modèle associé: {automation.templateTitre}
        </Typography>
        <Typography variant="body2" color="error" sx={{ mt: 2 }}>
          Cette action ne pourra pas être annulée. Les emails ne seront plus envoyés automatiquement selon cette règle.
        </Typography>
      </DialogContent>

      <DialogActions sx={{ padding: "16px 24px", backgroundColor: "#fafafa" }}>
        <Button
          onClick={onClose}
          variant="outlined"
          sx={{
            borderRadius: "8px",
            padding: "8px 16px",
            color: "primary.main",
            borderColor: "primary.main",
            "&:hover": {
              borderColor: "primary.dark",
              color: "primary.dark",
            },
          }}
        >
          Annuler
        </Button>
        <Button
          variant="contained"
          color="error"
          onClick={handleArchive}
          sx={{
            borderRadius: "8px",
            padding: "8px 16px",
            boxShadow: 2,
          }}
        >
          Archiver
        </Button>
      </DialogActions>
    </Dialog>
  )
}
