import * as Yup from 'yup';
import { IEmailAutomation, AutomationEvent, AutomationFrequency } from '@/shared/types/email-automation';

export const emailAutomationSchema = Yup.object().shape({
  nom: Yup.string()
    .required('Le nom de la règle est obligatoire')
    .min(3, 'Le nom doit contenir au moins 3 caractères')
    .max(100, 'Le nom ne doit pas dépasser 100 caractères'),
  templateId: Yup.string()
    .required('Le modèle d\'email est obligatoire'),
  templateTitre: Yup.string(),
  declencheur: Yup.object().shape({
    type: Yup.string()
      .required('Le type de déclencheur est obligatoire')
      .oneOf(['FREQUENCE', 'EVENEMENT'], 'Type de déclencheur invalide'),
    frequence: Yup.string()
      .when('type', {
        is: 'FREQUENCE',
        then: (schema) => schema
          .required('La fréquence est obligatoire')
          .oneOf(Object.values(AutomationFrequency), 'Fréquence invalide'),
        otherwise: (schema) => schema.notRequired(),
      }),
    evenement: Yup.string()
      .when('type', {
        is: 'EVENEMENT',
        then: (schema) => schema
          .required('L\'événement est obligatoire')
          .oneOf(Object.values(AutomationEvent), 'Événement invalide'),
        otherwise: (schema) => schema.notRequired(),
      }),
  }),
  destinataires: Yup.object().shape({
    type: Yup.string()
      .required('Le type de destinataire est obligatoire')
      .oneOf(['GROUPE', 'INDIVIDU'], 'Type de destinataire invalide'),
    groupes: Yup.array()
      .when('type', {
        is: 'GROUPE',
        then: (schema) => schema
          .required('Au moins un groupe doit être sélectionné')
          .min(1, 'Au moins un groupe doit être sélectionné'),
        otherwise: (schema) => schema.notRequired(),
      }),
    individus: Yup.array()
      .when('type', {
        is: 'INDIVIDU',
        then: (schema) => schema
          .required('Au moins un destinataire doit être sélectionné')
          .min(1, 'Au moins un destinataire doit être sélectionné'),
        otherwise: (schema) => schema.notRequired(),
      }),
  }),
  heureEnvoi: Yup.string()
    .required('L\'heure d\'envoi est obligatoire')
    .matches(/^([0-1]?[0-9]|2[0-3]):[0-5][0-9]$/, 'Format d\'heure invalide (HH:mm)'),
  isArchive: Yup.boolean()
    .required('Le statut d\'archivage est requis'),
}); 