"use client"
import React from 'react'
import SectorListView from './sector/view/sector-list-view'
import AgencyListView from './agency/view/agency-list-view'
import TabbedForm from '@/shared/components/tabs/tabbed-form'
import LotListView from './lot/view/lot-list-view'
import DepartmentListView from './department/view/department-list-view'
import { HEADER } from '@/layouts/config-layout'
import { Box } from '@mui/material'

export const InfastructureView = () => {
    const tabs = [
        {
            label: 'Secteurs',
            content: <SectorListView />
        },
        {
            label: 'Agences',
            content: <AgencyListView />
        },
        {
            label: 'Département',
            content: <DepartmentListView />
        },
        {
            label: 'Lots',
            content: <LotListView />
        },
    ]
    return (
        <Box
            sx={{
                display: 'flex',
                flexDirection: 'column',
                height: `calc(100vh - ${HEADER.H_DESKTOP + 8}px)`,
            }}
        >
            <TabbedForm
                tabs={tabs}
                isTransparent
                sx={{
                    fontWeight: 'bold',
                    color: '#F1F0FB',
                }}
            />
        </Box>
    )
}
